/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.rest;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.metrics.VitamCommonMetrics;
import fr.gouv.vitam.common.model.AuthenticationLevel;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.security.rest.VitamAuthentication;
import fr.gouv.vitam.logbook.common.model.reconstruction.ReconstructionRequestItem;
import fr.gouv.vitam.logbook.common.model.reconstruction.ReconstructionResponseItem;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookCollections;
import fr.gouv.vitam.logbook.common.server.reconstruction.ReconstructionService;
import io.prometheus.client.Histogram;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/logbook/v1")
@Tag(name="Logbook")
public class LogbookReconstructionResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookReconstructionResource.class);
    private final String RECONSTRUCTION_OPERATIONS_URI = "/reconstruction/operations";
    private static final String RECONSTRUCTION_JSON_MONDATORY_PARAMETERS_MSG = "the Json input of reconstruction's parameters is mondatory.";
    private static final String RECONSTRUCTION_EXCEPTION_MSG = "ERROR: Exception has been thrown when reconstructing Vitam collections: ";
    private final ReconstructionService reconstructionService;

    public LogbookReconstructionResource(ReconstructionService reconstructionService) {
        this.reconstructionService = reconstructionService;
    }

    @Path(value="/reconstruction/operations")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @VitamAuthentication(authentLevel=AuthenticationLevel.BASIC_AUTHENT)
    public Response reconstructCollection(List<ReconstructionRequestItem> reconstructionItems) {
        ParametersChecker.checkParameter((String)RECONSTRUCTION_JSON_MONDATORY_PARAMETERS_MSG, (Object[])new Object[]{reconstructionItems});
        ArrayList responses = new ArrayList();
        if (!reconstructionItems.isEmpty()) {
            LOGGER.debug(String.format("Starting reconstruction Vitam service with the json parameters : (%s)", reconstructionItems));
            reconstructionItems.forEach(item -> {
                LOGGER.debug(String.format("Starting reconstruction for the collection {%s} on the tenant (%s) with (%s) elements", LogbookCollections.OPERATION.name(), item.getTenant(), item.getLimit()));
                Histogram.Timer timer = ((Histogram.Child)VitamCommonMetrics.RECONSTRUCTION_DURATION.labels(new String[]{String.valueOf(item.getTenant()), LogbookCollections.OPERATION.name()})).startTimer();
                try {
                    responses.add(this.reconstructionService.reconstruct(item));
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error(RECONSTRUCTION_EXCEPTION_MSG, (Throwable)e);
                    responses.add(new ReconstructionResponseItem(item, StatusCode.KO));
                }
                finally {
                    timer.observeDuration();
                }
            });
        }
        return Response.ok().entity(responses).build();
    }
}

