/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.rest;

import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.client.OntologyLoader;
import fr.gouv.vitam.common.database.api.VitamRepositoryFactory;
import fr.gouv.vitam.common.database.api.VitamRepositoryProvider;
import fr.gouv.vitam.common.database.collections.CachedOntologyLoader;
import fr.gouv.vitam.common.database.offset.OffsetRepository;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import fr.gouv.vitam.common.serverv2.application.CommonBusinessApplication;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.client.AdminManagementOntologyLoader;
import fr.gouv.vitam.logbook.common.server.config.ElasticsearchLogbookIndexManager;
import fr.gouv.vitam.logbook.common.server.config.LogbookConfiguration;
import fr.gouv.vitam.logbook.common.server.config.LogbookConfigurationValidator;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookMongoDbAccessFactory;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookMongoDbAccessImpl;
import fr.gouv.vitam.logbook.common.server.reconstruction.LogbookReconstructionMetrics;
import fr.gouv.vitam.logbook.common.server.reconstruction.LogbookReconstructionMetricsCache;
import fr.gouv.vitam.logbook.common.server.reconstruction.ReconstructionService;
import fr.gouv.vitam.logbook.rest.LogbookAdminResource;
import fr.gouv.vitam.logbook.rest.LogbookRawResource;
import fr.gouv.vitam.logbook.rest.LogbookReconstructionResource;
import fr.gouv.vitam.logbook.rest.LogbookResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletConfig;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;

public class BusinessApplication
extends Application {
    private final CommonBusinessApplication commonBusinessApplication;
    private Set<Object> singletons;

    public BusinessApplication(@Context ServletConfig servletConfig) {
        String configurationFile = servletConfig.getInitParameter("vitam.configurationFile");
        try (InputStream yamlIS = PropertiesUtils.getConfigAsStream((String)configurationFile);){
            LogbookConfiguration configuration = (LogbookConfiguration)PropertiesUtils.readYaml((InputStream)yamlIS, LogbookConfiguration.class);
            LogbookConfigurationValidator.validateConfiguration((LogbookConfiguration)configuration);
            ElasticsearchLogbookIndexManager indexManager = new ElasticsearchLogbookIndexManager(configuration, VitamConfiguration.getTenants());
            this.commonBusinessApplication = new CommonBusinessApplication();
            CachedOntologyLoader ontologyLoader = new CachedOntologyLoader(VitamConfiguration.getOntologyCacheMaxEntries(), VitamConfiguration.getOntologyCacheTimeoutInSeconds(), (OntologyLoader)new AdminManagementOntologyLoader(AdminManagementClientFactory.getInstance(), Optional.empty()));
            LogbookMongoDbAccessImpl logbookMongoDbAccess = LogbookMongoDbAccessFactory.create((LogbookConfiguration)configuration, (OntologyLoader)ontologyLoader, (ElasticsearchLogbookIndexManager)indexManager);
            OffsetRepository offsetRepository = new OffsetRepository((MongoDbAccess)logbookMongoDbAccess);
            VitamRepositoryFactory vitamRepositoryProvider = VitamRepositoryFactory.get();
            this.singletons = new HashSet<Object>();
            this.singletons.addAll(this.commonBusinessApplication.getResources());
            this.singletons.add((Object)new LogbookResource(configuration, (OntologyLoader)ontologyLoader, indexManager));
            this.singletons.add(new LogbookRawResource((VitamRepositoryProvider)vitamRepositoryProvider, indexManager));
            this.singletons.add(new LogbookAdminResource((VitamRepositoryProvider)vitamRepositoryProvider, configuration));
            LogbookReconstructionMetricsCache reconstructionMetricsCache = new LogbookReconstructionMetricsCache((long)configuration.getReconstructionMetricsCacheDurationInMinutes(), TimeUnit.MINUTES);
            LogbookReconstructionMetrics.initialize((LogbookReconstructionMetricsCache)reconstructionMetricsCache);
            ReconstructionService reconstructionService = new ReconstructionService((VitamRepositoryProvider)vitamRepositoryProvider, offsetRepository, indexManager, reconstructionMetricsCache);
            this.singletons.add(new LogbookReconstructionResource(reconstructionService));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

