/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.filter;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.AuthenticationLevel;
import fr.gouv.vitam.common.model.BasicAuthModel;
import fr.gouv.vitam.common.server.application.configuration.DefaultVitamApplicationConfiguration;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

public class EndpointAuthenticationFilter
implements ContainerRequestFilter {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(EndpointAuthenticationFilter.class);
    private final AuthenticationLevel authentLevel;
    private final DefaultVitamApplicationConfiguration configuration;

    public EndpointAuthenticationFilter(AuthenticationLevel authentLevel, DefaultVitamApplicationConfiguration configuration) {
        this.authentLevel = authentLevel;
        this.configuration = configuration;
    }

    public void filter(ContainerRequestContext containerRequestContext) {
        Response errorResponse = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"VitamAuthentication failed: VitamAuthentication informations are missing.").build();
        try {
            ParametersChecker.checkParameter((String)"VitamAuthentication failed! The service needs user authentication.", (Object[])new Object[]{containerRequestContext.getHeaders().get((Object)"Authorization")});
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Throwable)e);
            containerRequestContext.abortWith(errorResponse);
            return;
        }
        MultivaluedMap headers = containerRequestContext.getHeaders();
        String authorization = (String)((List)headers.get((Object)"Authorization")).iterator().next();
        if (!authorization.startsWith("Basic")) {
            containerRequestContext.abortWith(errorResponse);
            return;
        }
        String decodedAuthent = "";
        String[] credentials = authorization.split("\\s");
        if (credentials.length != 2) {
            containerRequestContext.abortWith(errorResponse);
            return;
        }
        byte[] bytes = Base64.getDecoder().decode(credentials[1]);
        decodedAuthent = new String(bytes);
        List<String> decodedAuthentgInfos = Arrays.asList(decodedAuthent.split(":"));
        List basicAuthConfig = this.configuration.getAdminBasicAuth();
        if (decodedAuthentgInfos.isEmpty() || basicAuthConfig != null && (!((BasicAuthModel)basicAuthConfig.get(0)).getUserName().equals(decodedAuthentgInfos.get(0)) || !((BasicAuthModel)basicAuthConfig.get(0)).getPassword().equals(decodedAuthentgInfos.get(1)))) {
            containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"VitamAuthentication failed: Wrong credentials.").build());
        }
    }

    public AuthenticationLevel getAuthentLevel() {
        return this.authentLevel;
    }
}

