/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.filter;

import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class EndpointAdminOnlyAuthorizationFilter
implements ContainerRequestFilter {
    private static final String TENANT_ADMINISTRATION_IS_REQUIRED = "Tenant administration is required";
    private final boolean isAdminOnly;

    public EndpointAdminOnlyAuthorizationFilter(boolean isAdminOnly) {
        this.isAdminOnly = isAdminOnly;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        int tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        if (this.isAdminOnly && tenantId != VitamConfiguration.getAdminTenant()) {
            VitamError vitamError = this.generateVitamError();
            requestContext.abortWith(Response.status((int)vitamError.getHttpCode()).entity((Object)vitamError).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    private VitamError generateVitamError() {
        VitamError vitamError = new VitamError(VitamCodeHelper.getCode((VitamCode)VitamCode.INTERNAL_SECURITY_UNAUTHORIZED));
        vitamError.setContext(ServerIdentity.getInstance().getJsonIdentity()).setMessage(VitamCode.INTERNAL_SECURITY_UNAUTHORIZED.getMessage()).setDescription(TENANT_ADMINISTRATION_IS_REQUIRED).setState(VitamCode.INTERNAL_SECURITY_UNAUTHORIZED.name()).setHttpCode(VitamCode.INTERNAL_SECURITY_UNAUTHORIZED.getStatus().getStatusCode());
        return vitamError;
    }
}

