/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.filter;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.security.rest.Secured;
import fr.gouv.vitam.security.internal.filter.EndpointAdminOnlyAuthorizationFilter;
import fr.gouv.vitam.security.internal.filter.EndpointPermissionAuthorizationFilter;
import fr.gouv.vitam.security.internal.filter.EndpointPersonalCertificateAuthorizationFilter;
import javax.annotation.Priority;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;

@PreMatching
@Priority(value=3040)
public class AuthorizationFilter
implements DynamicFeature {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AuthorizationFilter.class);

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        Secured securedAnnotation = resourceInfo.getResourceMethod().getAnnotation(Secured.class);
        if (securedAnnotation == null) {
            LOGGER.debug(String.format("Ignoring Non-@%s annotated method %s.%s", Secured.class.getName(), resourceInfo.getResourceClass().getName(), resourceInfo.getResourceMethod().getName()));
            return;
        }
        LOGGER.debug(String.format("Registering authorization filters with '%s' permission for %s annotated method %s.%s", securedAnnotation.permission(), Secured.class.getName(), resourceInfo.getResourceClass().getName(), resourceInfo.getResourceMethod().getName()));
        context.register((Object)new EndpointAdminOnlyAuthorizationFilter(securedAnnotation.isAdminOnly()), 2010);
        context.register((Object)new EndpointPermissionAuthorizationFilter(securedAnnotation.permission().getPermission()), 2020);
        context.register((Object)new EndpointPersonalCertificateAuthorizationFilter(securedAnnotation.permission().getPermission()), 2030);
    }
}

