/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.server.database.collections;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.database.api.VitamRepositoryProvider;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.logbook.common.server.config.ElasticsearchLogbookIndexManager;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookCollections;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.Document;

public class LogbookRepositoryService {
    private final VitamRepositoryProvider vitamRepositoryProvider;
    private final ElasticsearchLogbookIndexManager indexManager;

    public LogbookRepositoryService(VitamRepositoryProvider vitamRepositoryProvider, ElasticsearchLogbookIndexManager indexManager) {
        this.vitamRepositoryProvider = vitamRepositoryProvider;
        this.indexManager = indexManager;
    }

    public void saveBulk(LogbookCollections collection, List<JsonNode> logbookItems) throws DatabaseException {
        List documents = logbookItems.stream().map(item -> Document.parse((String)JsonHandler.unprettyPrint((Object)item))).collect(Collectors.toList());
        this.vitamRepositoryProvider.getVitamMongoRepository(collection.getVitamCollection()).saveOrUpdate(documents);
        if (LogbookCollections.OPERATION.equals((Object)collection)) {
            this.vitamRepositoryProvider.getVitamESRepository(collection.getVitamCollection(), this.indexManager.getElasticsearchIndexAliasResolver(collection)).save(documents);
        }
    }
}

