/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.server.database.collections;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameters;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycleMongoDbName;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookMongoDbName;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bson.Document;

public class LogbookLifeCycle<T>
extends VitamDocument<LogbookLifeCycle<T>> {
    private static final long serialVersionUID = 105654500015427902L;

    public LogbookLifeCycle() {
    }

    public LogbookLifeCycle(LogbookParameters parameters) {
        ParametersChecker.checkParameter((String)"parameters", (Object[])new Object[]{parameters});
        Map map = parameters.getMapParameters();
        for (LogbookLifeCycleMongoDbName name : LogbookLifeCycleMongoDbName.values()) {
            this.append(name.getDbname(), map.get(name.getLogbookParameterName()));
        }
        this.append("events", Collections.emptyList());
        this.checkId();
    }

    public LogbookLifeCycle(Document content) {
        super(content);
    }

    public VitamDocument<LogbookLifeCycle<T>> newInstance(JsonNode content) {
        return new LogbookLifeCycle<T>(content);
    }

    public LogbookLifeCycle(String content) {
        super(content);
    }

    public LogbookLifeCycle(JsonNode content) {
        super(content);
    }

    static LogbookMongoDbName getIdName() {
        return LogbookMongoDbName.objectIdentifier;
    }

    static LogbookParameterName getIdParameterName() {
        return LogbookParameterName.objectIdentifier;
    }

    public final String getId() {
        return this.getString(LogbookLifeCycle.getIdName().getDbname());
    }

    public List<Document> events() {
        return this.getList("events", Document.class);
    }
}

