/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ihmdemo.common.utils;

import com.google.common.collect.Lists;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.subject.Subject;

public class PermissionReader {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PermissionReader.class);

    public static Set<String> getMethodsAnnotatedWith(Class<?> type, Class<? extends RequiresPermissions> annotation) {
        HashSet<String> methods = new HashSet<String>();
        for (Class<?> klass = type; klass != Object.class; klass = klass.getSuperclass()) {
            ArrayList<Method> allMethods = new ArrayList<Method>(Arrays.asList(klass.getDeclaredMethods()));
            for (Method method : allMethods) {
                if (!method.isAnnotationPresent(annotation)) continue;
                RequiresPermissions annotInstance = method.getAnnotation(annotation);
                methods.addAll(Lists.newArrayList((Object[])annotInstance.value()));
            }
        }
        return methods;
    }

    public static List<String> filterPermission(Collection<String> permissions, Subject subject) {
        ArrayList<String> filteringPermissions = new ArrayList<String>();
        for (String permission : permissions) {
            try {
                subject.checkPermission(permission);
                filteringPermissions.add(permission);
            }
            catch (AuthorizationException e) {
                LOGGER.debug("user has no permission {}", (Object)permission);
            }
        }
        return filteringPermissions;
    }
}

