/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ihmdemo.common.pagination;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.ihmdemo.common.pagination.OffsetBasedPagination;
import java.util.Collection;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.DefaultSessionManager;

public class PaginationHelper {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PaginationHelper.class);
    private static final String PARAMETERS = "PaginationHelper parameters";
    private static final String RESULT_SESSION_ATTRIBUTE = "$results";
    private static final String JSON_NODE_RESULT = "$results";
    private static final String JSON_NODE_HITS = "$hits";
    private static final String JSON_NODE_OFFSET = "offset";
    private static final String JSON_NODE_LIMIT = "limit";
    private static final PaginationHelper instance = new PaginationHelper();

    public static PaginationHelper getInstance() {
        return instance;
    }

    public void setResult(String sessionId, JsonNode result) throws VitamException {
        ParametersChecker.checkParameter((String)PARAMETERS, (Object[])new Object[]{sessionId, result});
        Session session = this.getSession(sessionId);
        session.setAttribute((Object)"$results", (Object)result);
    }

    public JsonNode getResult(String sessionId, OffsetBasedPagination pagination) throws VitamException {
        Session session = this.getSession(sessionId);
        ObjectNode result = (ObjectNode)session.getAttribute((Object)"$results");
        if (result != null) {
            return this.paginate(result, pagination);
        }
        return JsonHandler.createObjectNode();
    }

    public JsonNode getResult(JsonNode result, OffsetBasedPagination pagination) throws VitamException {
        ObjectNode jsonResult = (ObjectNode)result;
        return this.paginate(jsonResult, pagination);
    }

    private Session getSession(String sessionId) throws VitamException {
        try {
            DefaultSecurityManager securityManager = (DefaultSecurityManager)SecurityUtils.getSecurityManager();
            DefaultSessionManager sessionManager = (DefaultSessionManager)securityManager.getSessionManager();
            Collection activeSessions = sessionManager.getSessionDAO().getActiveSessions();
            for (Session session : activeSessions) {
                if (!session.getId().equals(sessionId)) continue;
                return session;
            }
            throw new VitamException("Session Not Found Exception");
        }
        catch (UnavailableSecurityManagerException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            throw new VitamException(e.getMessage(), (Throwable)e);
        }
    }

    public JsonNode paginate(ObjectNode result, OffsetBasedPagination pagination) throws InvalidParseOperationException {
        ObjectNode jsonResult = (ObjectNode)JsonHandler.toJsonNode((Object)result);
        Object resultsPagination = pagination != null ? JsonHandler.getSubArrayNode((ArrayNode)((ArrayNode)jsonResult.get("$results")), (int)pagination.getOffset(), (int)pagination.getLimit()) : jsonResult.get("$results");
        jsonResult.replace("$results", resultsPagination);
        ObjectNode hits = (ObjectNode)jsonResult.get(JSON_NODE_HITS);
        if (pagination != null) {
            hits.put(JSON_NODE_OFFSET, pagination.getOffset());
            hits.put(JSON_NODE_LIMIT, pagination.getLimit());
        } else {
            hits.put(JSON_NODE_OFFSET, 0);
            hits.put(JSON_NODE_LIMIT, 10000);
        }
        jsonResult.replace(JSON_NODE_HITS, (JsonNode)hits);
        return jsonResult;
    }
}

