/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ihmrecette.appserver.performance;

import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.logbook.LogbookEventOperation;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.text.ParseException;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

public class ReportGenerator
implements AutoCloseable {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ReportGenerator.class);
    private static final String STARTED_SUFFIX = ".STARTED";
    private BufferedWriter writer;
    private boolean headerAlreadyGenerated;

    ReportGenerator(Path path) throws IOException {
        this.writer = Files.newBufferedWriter(path, StandardOpenOption.CREATE);
        this.headerAlreadyGenerated = false;
    }

    void generateReport(String operationId, LogbookOperation logbookOperation) throws IOException {
        if (!this.headerAlreadyGenerated) {
            this.generateReportHeader(logbookOperation);
        }
        this.generateReportLine(operationId, logbookOperation);
    }

    private void generateReportHeader(LogbookOperation logbookOperation) throws IOException {
        LinkedHashSet<String> headers = new LinkedHashSet<String>();
        headers.add("operationId");
        headers.add(logbookOperation.getEvType());
        List events = logbookOperation.getEvents();
        events.iterator().forEachRemaining(event -> headers.add(event.getEvType().replace(STARTED_SUFFIX, "")));
        this.writer.write(String.join((CharSequence)",", headers));
        this.writer.newLine();
        this.headerAlreadyGenerated = true;
    }

    private void generateReportLine(String operationId, LogbookOperation logbookOperation) throws IOException {
        String referenceDate = logbookOperation.getEvDateTime();
        String firstEventType = logbookOperation.getEvType();
        List events = logbookOperation.getEvents();
        LinkedHashMap<String, Interval> map = new LinkedHashMap<String, Interval>();
        map.put(firstEventType, new Interval(referenceDate));
        for (LogbookEventOperation event : events) {
            String evType = event.getEvType();
            String evDateTime = event.getEvDateTime();
            if (evType.endsWith(STARTED_SUFFIX)) {
                evType = evType.replace(STARTED_SUFFIX, "");
                map.put(evType, new Interval(evDateTime));
                referenceDate = evDateTime;
                continue;
            }
            if (map.containsKey(evType)) {
                ((Interval)map.get(evType)).setEndDate(evDateTime);
                continue;
            }
            Interval anInterval = new Interval(referenceDate);
            anInterval.setEndDate(evDateTime);
            map.put(evType, anInterval);
            referenceDate = evDateTime;
        }
        this.writer.write(String.format("%s,%s", operationId, map.values().stream().map(Interval::total).collect(Collectors.joining(","))));
        this.writer.newLine();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private static class Interval {
        private String startDate;
        private String endDate;

        Interval(String startDate) {
            this.startDate = startDate;
        }

        void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        String total() {
            try {
                Date startDateTime = LocalDateUtil.getDate((String)this.startDate);
                Date endDateTime = LocalDateUtil.getDate((String)this.endDate);
                return String.valueOf(endDateTime.getTime() - startDateTime.getTime());
            }
            catch (IllegalArgumentException | ParseException | DateTimeParseException e) {
                LOGGER.error(String.format("unable to parse date: %s or %s", this.startDate, this.endDate));
                return "";
            }
        }
    }
}

