/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ihmrecette.appserver.performance;

import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.client.AdminExternalClientFactory;
import fr.gouv.vitam.access.external.client.OperationStatusClient;
import fr.gouv.vitam.access.external.client.VitamPoolingClient;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ProcessAction;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitam.common.security.IllegalPathException;
import fr.gouv.vitam.common.security.SafeFileChecker;
import fr.gouv.vitam.common.thread.VitamThreadFactory;
import fr.gouv.vitam.ihmdemo.core.UserInterfaceTransactionManager;
import fr.gouv.vitam.ihmrecette.appserver.performance.PerformanceModel;
import fr.gouv.vitam.ihmrecette.appserver.performance.ReportGenerator;
import fr.gouv.vitam.ingest.external.client.IngestExternalClient;
import fr.gouv.vitam.ingest.external.client.IngestExternalClientFactory;
import fr.gouv.vitam.logbook.common.parameters.Contexts;
import io.reactivex.Flowable;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class PerformanceService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PerformanceService.class);
    private static final String DEFAULT_CONTRACT_NAME = "test_perf";
    private static final int NUMBER_OF_RETRY = 100;
    private static final String APP_SESSION_ID = "MyApplicationId-ChangeIt";
    private final IngestExternalClientFactory ingestClientFactory;
    private final AdminExternalClientFactory adminClientFactory;
    private final UserInterfaceTransactionManager userInterfaceTransactionManager;
    private static final String UNABLE_TO_UPLOAD_SIP = "unable to upload sip";
    private AtomicBoolean performanceTestInProgress = new AtomicBoolean(false);
    private final Path sipDirectory;
    private final Path performanceReportDirectory;

    public PerformanceService(Path sipDirectory, Path performanceReportDirectory) {
        this(IngestExternalClientFactory.getInstance(), AdminExternalClientFactory.getInstance(), sipDirectory, performanceReportDirectory, UserInterfaceTransactionManager.getInstance());
    }

    PerformanceService(IngestExternalClientFactory ingestClientFactory, AdminExternalClientFactory adminClientFactory, Path sipDirectory, Path performanceReportDirectory, UserInterfaceTransactionManager userInterfaceTransactionManager) {
        this.sipDirectory = sipDirectory;
        this.ingestClientFactory = ingestClientFactory;
        this.adminClientFactory = adminClientFactory;
        this.performanceReportDirectory = performanceReportDirectory;
        this.userInterfaceTransactionManager = userInterfaceTransactionManager;
    }

    boolean inProgress() {
        return this.performanceTestInProgress.get();
    }

    void launchPerformanceTest(PerformanceModel model, String fileName, int tenantId) throws IOException {
        if (model.getParallelIngest() != null) {
            this.launchTestInParallel(model, fileName, tenantId);
            return;
        }
        if (model.getDelay() != null) {
            this.launchTestInSequence(model, fileName, tenantId);
        }
    }

    private void launchTestInSequence(PerformanceModel model, String fileName, int tenantId) throws IOException {
        ReportGenerator reportGenerator = new ReportGenerator(this.performanceReportDirectory.resolve(fileName));
        int numberOfRetry = model.getNumberOfRetry() == null ? 100 : model.getNumberOfRetry();
        this.performanceTestInProgress.set(true);
        Flowable.interval((long)0L, (long)model.getDelay().intValue(), (TimeUnit)TimeUnit.MILLISECONDS).take((long)model.getNumberOfIngest()).map(i -> this.upload(model, tenantId)).flatMap(operationId -> Flowable.just((Object)operationId).observeOn(Schedulers.io()).map(id -> this.waitEndOfIngest(tenantId, numberOfRetry, (String)id))).subscribe(operationId -> this.generateReport(reportGenerator, (String)operationId, tenantId), throwable -> {
            LOGGER.error("end performance test with error", throwable);
            this.performanceTestInProgress.set(false);
        }, () -> {
            try {
                reportGenerator.close();
                this.performanceTestInProgress.set(false);
                LOGGER.info("end performance test");
            }
            catch (IOException e) {
                LOGGER.error("unable to close report", (Throwable)e);
            }
        });
    }

    private void launchTestInParallel(PerformanceModel model, String fileName, int tenantId) throws IOException {
        ExecutorService launcherPerformanceExecutor = Executors.newFixedThreadPool(model.getParallelIngest(), (ThreadFactory)VitamThreadFactory.getInstance());
        ExecutorService reportExecutor = Executors.newSingleThreadExecutor((ThreadFactory)VitamThreadFactory.getInstance());
        LOGGER.info("start performance test");
        ReportGenerator reportGenerator = new ReportGenerator(this.performanceReportDirectory.resolve(fileName));
        this.performanceTestInProgress.set(true);
        List collect = IntStream.range(0, model.getNumberOfIngest()).mapToObj(i -> CompletableFuture.supplyAsync(() -> this.uploadSIP(model, tenantId), launcherPerformanceExecutor)).map(future -> future.thenAcceptAsync(id -> this.generateReport(reportGenerator, (String)id, tenantId), (Executor)reportExecutor)).collect(Collectors.toList());
        CompletableFuture allDone = this.sequence(collect);
        ((CompletableFuture)allDone.thenRun(() -> {
            try {
                reportGenerator.close();
                launcherPerformanceExecutor.shutdown();
                reportExecutor.shutdown();
                this.performanceTestInProgress.set(false);
                LOGGER.info("end performance test");
            }
            catch (IOException e) {
                LOGGER.error("unable to close report", (Throwable)e);
            }
        })).exceptionally(e -> {
            LOGGER.error("end performance test with error", e);
            this.performanceTestInProgress.set(false);
            return null;
        });
    }

    private void generateReport(ReportGenerator reportGenerator, String operationId, int tenantId) {
        try {
            LOGGER.debug("generate report");
            VitamContext context = new VitamContext(Integer.valueOf(tenantId));
            context.setAccessContract(DEFAULT_CONTRACT_NAME).setApplicationSessionId(APP_SESSION_ID);
            RequestResponse requestResponse = this.userInterfaceTransactionManager.selectOperationbyId(operationId, context);
            if (requestResponse.isOk()) {
                RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
                LogbookOperation logbookOperation = (LogbookOperation)requestResponseOK.getFirstResult();
                reportGenerator.generateReport(operationId, logbookOperation);
            }
        }
        catch (VitamException | IOException e) {
            LOGGER.error("unable to generate report", e);
        }
    }

    /*
     * Exception decompiling
     */
    private String uploadSIP(PerformanceModel model, Integer tenantId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String waitEndOfIngest(int tenantId, int numberOfRetry, String operationId) {
        String string;
        block8: {
            LOGGER.debug("wait end of ingest");
            AdminExternalClient adminClient = this.adminClientFactory.getClient();
            try {
                VitamPoolingClient vitamPoolingClient = new VitamPoolingClient((OperationStatusClient)adminClient);
                vitamPoolingClient.wait(tenantId, operationId, ProcessState.COMPLETED, numberOfRetry, 1000L, TimeUnit.MILLISECONDS);
                LOGGER.debug("finish unitary test");
                string = operationId;
                if (adminClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (adminClient != null) {
                        try {
                            adminClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error(UNABLE_TO_UPLOAD_SIP, (Throwable)e);
                    return null;
                }
            }
            adminClient.close();
        }
        return string;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String upload(PerformanceModel model, int tenantId) {
        LOGGER.debug("launch unitary ingest");
        try (InputStream sipInputStream = Files.newInputStream(this.sipDirectory.resolve(model.getFileName()), StandardOpenOption.READ);){
            String string;
            block14: {
                IngestExternalClient client = this.ingestClientFactory.getClient();
                try {
                    RequestResponse response = client.ingest(new VitamContext(Integer.valueOf(tenantId)), sipInputStream, Contexts.DEFAULT_WORKFLOW.name(), ProcessAction.RESUME.name());
                    string = response.getHeaderString("X-Request-Id");
                    if (client == null) break block14;
                }
                catch (Throwable throwable) {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                client.close();
            }
            return string;
        }
        catch (Exception e) {
            LOGGER.error(UNABLE_TO_UPLOAD_SIP, (Throwable)e);
            return null;
        }
    }

    private <T> CompletableFuture<List<T>> sequence(List<CompletableFuture<T>> futures) {
        CompletableFuture<Void> allDoneFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        return allDoneFuture.thenApply(v -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    List<Path> listSipDirectory() throws IOException {
        final ArrayList<Path> paths = new ArrayList<Path>();
        Files.walkFileTree(this.sipDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.toString().toLowerCase().endsWith("zip")) {
                    paths.add(PerformanceService.this.sipDirectory.relativize(file));
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return paths;
    }

    List<Path> listReportDirectory() throws IOException {
        return this.listDirectory(this.performanceReportDirectory);
    }

    boolean sipExist(String sipPath) {
        return this.sipDirectory.resolve(sipPath).toFile().exists();
    }

    InputStream readReport(String reportName) throws IOException, IllegalPathException {
        File file = SafeFileChecker.checkSafeFilePath((String)this.performanceReportDirectory.toAbsolutePath().toString(), (String[])new String[]{reportName});
        return Files.newInputStream(file.toPath(), new OpenOption[0]);
    }

    private List<Path> listDirectory(Path directory) throws IOException {
        try (Stream<Path> pathStream = Files.list(directory);){
            List<Path> list = pathStream.collect(Collectors.toList());
            return list;
        }
    }
}

