/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ihmrecette.appserver.applicativetest;

import com.google.common.base.Throwables;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.logging.SysErrLogger;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.VitamThreadFactory;
import fr.gouv.vitam.ihmrecette.appserver.applicativetest.ApplicativeTestResource;
import fr.gouv.vitam.ihmrecette.appserver.applicativetest.CucumberLauncher;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.queue.CircularFifoQueue;

public class ApplicativeTestService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ApplicativeTestResource.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
    private static final String GLUE_CODE_PACKAGE = "fr.gouv.vitam.functionaltest.cucumber";
    private static final String PROCESS_EXIT_STATUS = "process exit status ";
    private AtomicBoolean inProgress;
    private Executor executor;
    private AtomicBoolean isTnrMasterActived;
    private String tnrBranch = "master";
    private CucumberLauncher cucumberLauncher;
    private Path tnrReportDirectory;

    public ApplicativeTestService(Path tnrReportDirectory) {
        this.tnrReportDirectory = tnrReportDirectory;
        this.inProgress = new AtomicBoolean(false);
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)VitamThreadFactory.getInstance());
        this.cucumberLauncher = new CucumberLauncher(tnrReportDirectory);
        this.isTnrMasterActived = new AtomicBoolean(false);
    }

    String launchCucumberTest(Path featurePath) {
        if (!featurePath.toFile().exists()) {
            throw new VitamRuntimeException("path does not exist: " + featurePath);
        }
        String fileName = String.format("report_%s.json", LocalDateUtil.now().format(DATE_TIME_FORMATTER));
        this.inProgress.set(true);
        this.executor.execute(() -> {
            List<String> arguments = this.cucumberLauncher.buildCucumberArgument(GLUE_CODE_PACKAGE, featurePath, fileName);
            try {
                this.cucumberLauncher.launchCucumberTest(arguments);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            this.inProgress.set(false);
        });
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String launchPiecesCucumberTest(String pieces) throws IOException {
        File reportFile = File.createTempFile("tmp", ".json", new File(VitamConfiguration.getVitamTmpFolder()));
        File featureFile = File.createTempFile("tmp", ".feature", new File(VitamConfiguration.getVitamTmpFolder()));
        try {
            Files.write(featureFile.toPath(), pieces.getBytes(), new OpenOption[0]);
            List<String> arguments = this.cucumberLauncher.buildCucumberArgument(GLUE_CODE_PACKAGE, featureFile.toPath(), reportFile.getAbsolutePath());
            this.cucumberLauncher.launchCucumberTest(arguments);
            String string = String.join((CharSequence)System.lineSeparator(), Files.readAllLines(reportFile.toPath()));
            return string;
        }
        finally {
            Files.deleteIfExists(featureFile.toPath());
            Files.deleteIfExists(reportFile.toPath());
        }
    }

    boolean inProgress() {
        return this.inProgress.get();
    }

    List<Path> reports() throws IOException {
        try (Stream<Path> pathStream = Files.list(this.tnrReportDirectory);){
            List<Path> list = pathStream.collect(Collectors.toList());
            return list;
        }
    }

    InputStream readReport(String fileName) throws IOException {
        return Files.newInputStream(this.tnrReportDirectory.resolve(fileName), new OpenOption[0]);
    }

    int synchronizedTestDirectory(Path featurePath) throws IOException, InterruptedException {
        LOGGER.debug("git pull rebase on " + featurePath);
        ProcessBuilder pb = new ProcessBuilder("git", "pull", "--rebase");
        pb.directory(featurePath.toFile());
        Process p = pb.start();
        p.waitFor();
        LOGGER.debug(PROCESS_EXIT_STATUS + p.exitValue());
        return p.exitValue();
    }

    int checkout(Path featurePath, String branch) throws IOException, InterruptedException {
        LOGGER.debug("git checkout" + branch);
        ProcessBuilder pb = new ProcessBuilder("git", "checkout", branch);
        pb.directory(featurePath.toFile());
        Process p = pb.start();
        p.waitFor();
        LOGGER.debug(PROCESS_EXIT_STATUS + p.exitValue());
        return p.exitValue();
    }

    List<String> getBranches(Path featurePath) throws IOException, InterruptedException {
        LOGGER.debug("git get branches");
        ProcessBuilder pb = new ProcessBuilder("git", "for-each-ref", "--sort=-committerdate", "refs/remotes/", "--format='%(refname:short)'");
        pb.directory(featurePath.toFile());
        Process p = pb.start();
        p.waitFor();
        String stdout = ApplicativeTestService.stdToString(p.getInputStream());
        LOGGER.debug("process output " + stdout);
        return Arrays.asList(stdout.replaceAll("'", "").replaceAll("[[a-zA-Z0-9]_]+/", "").split(" \\| "));
    }

    private static String stdToString(InputStream std) {
        CircularFifoQueue lastLines = new CircularFifoQueue(250);
        ArrayList<String> firstLines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(std, StandardCharsets.UTF_8));){
            String c;
            while ((c = reader.readLine()) != null) {
                if (firstLines.size() < 250) {
                    firstLines.add(c);
                    continue;
                }
                lastLines.add((Object)c);
            }
        }
        catch (IOException e) {
            SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e);
            return Stream.concat(firstLines.stream(), lastLines.stream()).collect(Collectors.joining(" | ")) + "|" + e.getMessage();
        }
        return Stream.concat(firstLines.stream(), lastLines.stream()).collect(Collectors.joining(" | "));
    }

    int reset(Path featurePath, String branch) throws InterruptedException, IOException {
        LOGGER.debug("git reset origin/" + branch);
        ProcessBuilder processBuilder = new ProcessBuilder("git", "reset", "--hard", "origin/" + branch);
        processBuilder.directory(featurePath.toFile());
        Process process = processBuilder.start();
        process.waitFor();
        LOGGER.debug(PROCESS_EXIT_STATUS + process.exitValue());
        return process.exitValue();
    }

    void fetch(Path featurePath) throws InterruptedException, IOException {
        ProcessBuilder processBuilder = new ProcessBuilder("git", "fetch");
        processBuilder.directory(featurePath.toFile());
        Process process = processBuilder.start();
        process.waitFor();
        LOGGER.debug(PROCESS_EXIT_STATUS + process.exitValue());
        process.exitValue();
    }

    void setIsTnrMasterActived(AtomicBoolean isTnrMasterActived) {
        this.isTnrMasterActived = isTnrMasterActived;
    }

    AtomicBoolean getIsTnrMasterActived() {
        return this.isTnrMasterActived;
    }

    String getTnrBranch() {
        return this.tnrBranch;
    }

    void setTnrBranch(String tnrBranch) {
        this.tnrBranch = tnrBranch;
    }
}

