/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.api;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import java.util.ArrayList;
import java.util.List;

public interface WorkerAction {
    default public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        throw new IllegalStateException("Not implemented.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public List<ItemStatus> executeList(WorkerParameters workerParameters, HandlerIO handler) throws ProcessingException {
        try {
            ArrayList<ItemStatus> aggregateItemStatus = new ArrayList<ItemStatus>();
            List<String> objectNameList = workerParameters.getObjectNameList();
            List<JsonNode> objectMetadataList = workerParameters.getObjectMetadataList();
            for (int i = 0; i < objectNameList.size(); ++i) {
                String objectId = objectNameList.get(i);
                JsonNode metadata = objectMetadataList != null && !objectMetadataList.isEmpty() ? objectMetadataList.get(i) : null;
                workerParameters.setObjectName(objectId);
                workerParameters.setObjectMetadata(metadata);
                handler.setCurrentObjectId(objectId);
                ItemStatus itemStatus = this.execute(workerParameters, handler);
                aggregateItemStatus.add(itemStatus);
            }
            ArrayList<ItemStatus> arrayList = aggregateItemStatus;
            return arrayList;
        }
        finally {
            handler.setCurrentObjectId(null);
        }
    }

    default public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
        throw new IllegalStateException("Not implemented.");
    }
}

