/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.common.parameter;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.processing.common.parameter.DefaultWorkerParameters;
import fr.gouv.vitam.processing.common.parameter.WorkerParameterName;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class WorkerParametersFactory {
    private static final Set<WorkerParameterName> genericMandatories = new HashSet<WorkerParameterName>();

    private WorkerParametersFactory() {
    }

    static DefaultWorkerParameters newWorkerParameters(Set<WorkerParameterName> mandatoryFieldsToAdd) {
        return new DefaultWorkerParameters(WorkerParametersFactory.initMandatoriesParameters(mandatoryFieldsToAdd));
    }

    public static DefaultWorkerParameters newWorkerParameters() {
        return new DefaultWorkerParameters(WorkerParametersFactory.initMandatoriesParameters(null));
    }

    public static DefaultWorkerParameters newWorkerParameters(String processId, String stepUniqId, String containerName, String currentStep, List<String> objectNameList, String urlMetadata, String urlWorkspace) {
        ParametersChecker.checkParameter((String)"Parameters cannot be null or empty", (Object[])new Object[]{processId, stepUniqId, containerName, currentStep, objectNameList, urlMetadata, urlWorkspace});
        DefaultWorkerParameters parameters = new DefaultWorkerParameters(WorkerParametersFactory.initMandatoriesParameters(null));
        parameters.putParameterValue(WorkerParameterName.processId, processId);
        parameters.putParameterValue(WorkerParameterName.stepUniqId, stepUniqId);
        parameters.putParameterValue(WorkerParameterName.containerName, containerName);
        parameters.putParameterValue(WorkerParameterName.currentStep, currentStep);
        parameters.setObjectNameList((List)objectNameList);
        parameters.putParameterValue(WorkerParameterName.urlMetadata, urlMetadata);
        parameters.putParameterValue(WorkerParameterName.urlWorkspace, urlWorkspace);
        return parameters;
    }

    static Set<WorkerParameterName> getDefaultMandatory() {
        return Collections.unmodifiableSet(new HashSet<WorkerParameterName>(genericMandatories));
    }

    private static Set<WorkerParameterName> initMandatoriesParameters(Set<WorkerParameterName> mandatoryFieldsToAdd) {
        HashSet<WorkerParameterName> mandatory = new HashSet<WorkerParameterName>(genericMandatories);
        if (mandatoryFieldsToAdd != null) {
            mandatory.addAll(mandatoryFieldsToAdd);
        }
        return Collections.unmodifiableSet(mandatory);
    }

    static {
        genericMandatories.add(WorkerParameterName.urlMetadata);
        genericMandatories.add(WorkerParameterName.urlWorkspace);
        genericMandatories.add(WorkerParameterName.objectNameList);
        genericMandatories.add(WorkerParameterName.currentStep);
        genericMandatories.add(WorkerParameterName.containerName);
    }
}

