/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.common.parameter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.processing.common.parameter.WorkerParameterName;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.processing.common.parameter.WorkerParametersDeserializer;
import fr.gouv.vitam.processing.common.parameter.WorkerParametersFactory;
import fr.gouv.vitam.processing.common.parameter.WorkerParametersSerializer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

@JsonSerialize(using=WorkerParametersSerializer.class)
@JsonDeserialize(using=WorkerParametersDeserializer.class)
abstract class AbstractWorkerParameters
implements WorkerParameters {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AbstractWorkerParameters.class);
    private static final String ERROR_MESSAGE = "%s cannot be null";
    @JsonIgnore
    protected final Map<WorkerParameterName, String> mapParameters = new TreeMap<WorkerParameterName, String>();
    @JsonIgnore
    protected final Set<WorkerParameterName> mandatoryParameters;

    AbstractWorkerParameters(Set<WorkerParameterName> mandatory) {
        this.mandatoryParameters = mandatory;
    }

    @JsonCreator
    protected AbstractWorkerParameters(Map<String, String> map) {
        this.mandatoryParameters = WorkerParametersFactory.getDefaultMandatory();
        this.setMap(map);
    }

    @JsonIgnore
    public Set<WorkerParameterName> getMandatoriesParameters() {
        return Collections.unmodifiableSet(new HashSet<WorkerParameterName>(this.mandatoryParameters));
    }

    @JsonIgnore
    public Map<WorkerParameterName, String> getMapParameters() {
        return Collections.unmodifiableMap(new HashMap<WorkerParameterName, String>(this.mapParameters));
    }

    @Override
    @JsonIgnore
    public WorkerParameters putParameterValue(WorkerParameterName parameterName, String parameterValue) {
        ParametersChecker.checkNullOrEmptyParameter((Enum)parameterName, (String)parameterValue, this.getMandatoriesParameters());
        this.mapParameters.put(parameterName, parameterValue);
        return this;
    }

    @Override
    @JsonIgnore
    public String getParameterValue(WorkerParameterName parameterName) {
        ParametersChecker.checkParameter((String)String.format(ERROR_MESSAGE, "parameterName"), (Object[])new Object[]{parameterName});
        return this.mapParameters.get((Object)parameterName);
    }

    @Override
    @JsonIgnore
    public WorkerParameters setMap(Map<String, String> map) {
        ParametersChecker.checkParameter((String)String.format(ERROR_MESSAGE, "map"), (Object[])new Object[]{map});
        for (String key : map.keySet()) {
            if (!WorkerParameterName.getEnums().contains(key)) continue;
            this.mapParameters.put(WorkerParameterName.valueOf(key), map.get(key));
        }
        return this;
    }

    @Override
    @JsonIgnore
    public String getCurrentStep() {
        return this.mapParameters.get((Object)WorkerParameterName.currentStep);
    }

    @Override
    @JsonIgnore
    public WorkerParameters setCurrentStep(String currentStep) {
        ParametersChecker.checkParameter((String)String.format(ERROR_MESSAGE, "currentStep"), (String[])new String[]{currentStep});
        this.mapParameters.put(WorkerParameterName.currentStep, currentStep);
        return this;
    }

    @Override
    @JsonIgnore
    public String getPreviousStep() {
        return this.mapParameters.get((Object)WorkerParameterName.previousStep);
    }

    @Override
    @JsonIgnore
    public WorkerParameters setPreviousStep(String previousStep) {
        this.mapParameters.put(WorkerParameterName.previousStep, previousStep);
        return this;
    }

    @Override
    @JsonIgnore
    public String getContainerName() {
        return this.mapParameters.get((Object)WorkerParameterName.containerName);
    }

    @Override
    @JsonIgnore
    public WorkerParameters setContainerName(String containerName) {
        ParametersChecker.checkParameter((String)String.format(ERROR_MESSAGE, "containerName"), (String[])new String[]{containerName});
        this.mapParameters.put(WorkerParameterName.containerName, containerName);
        return this;
    }

    @Override
    @JsonIgnore
    public String getObjectId() {
        return this.mapParameters.get((Object)WorkerParameterName.objectId);
    }

    @Override
    @JsonIgnore
    public WorkerParameters setObjectId(String objectId) {
        ParametersChecker.checkParameter((String)String.format(ERROR_MESSAGE, "objectId"), (String[])new String[]{objectId});
        this.mapParameters.put(WorkerParameterName.objectId, objectId);
        return this;
    }

    @Override
    @JsonIgnore
    public String getObjectName() {
        return this.mapParameters.get((Object)WorkerParameterName.objectName);
    }

    @Override
    @JsonIgnore
    public WorkerParameters setObjectName(String objectName) {
        ParametersChecker.checkParameter((String)String.format(ERROR_MESSAGE, "objectName"), (String[])new String[]{objectName});
        this.mapParameters.put(WorkerParameterName.objectName, objectName);
        return this;
    }

    @Override
    @JsonIgnore
    public JsonNode getObjectMetadata() {
        try {
            return JsonHandler.getFromString((String)this.mapParameters.get((Object)WorkerParameterName.objectMetadata));
        }
        catch (InvalidParseOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    @JsonIgnore
    public WorkerParameters setObjectMetadata(JsonNode objectMetadata) {
        if (objectMetadata != null) {
            this.mapParameters.put(WorkerParameterName.objectMetadata, JsonHandler.unprettyPrint((Object)objectMetadata));
        }
        return this;
    }

    @Override
    @JsonIgnore
    public List<String> getObjectNameList() {
        String objectList = this.mapParameters.get((Object)WorkerParameterName.objectNameList);
        try {
            return (List)JsonHandler.getFromString((String)objectList, List.class, String.class);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    @JsonIgnore
    public WorkerParameters setObjectNameList(List<String> objectNameList) {
        ParametersChecker.checkParameter((String)String.format(ERROR_MESSAGE, "objectNameList"), (Object[])new Object[]{objectNameList});
        try {
            this.mapParameters.put(WorkerParameterName.objectNameList, JsonHandler.writeAsString(objectNameList));
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    @Override
    @JsonIgnore
    public List<JsonNode> getObjectMetadataList() {
        String objectList = this.mapParameters.get((Object)WorkerParameterName.objectMetadataList);
        if (objectList == null) {
            return null;
        }
        try {
            return (List)JsonHandler.getFromString((String)objectList, List.class, JsonNode.class);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    @JsonIgnore
    public WorkerParameters setObjectMetadataList(List<JsonNode> objectMetaDataList) {
        ParametersChecker.checkParameter((String)String.format(ERROR_MESSAGE, "objectMetaDataList"), (Object[])new Object[]{objectMetaDataList});
        try {
            this.mapParameters.put(WorkerParameterName.objectMetadataList, JsonHandler.writeAsString(objectMetaDataList));
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error((Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    @Override
    @JsonIgnore
    public String getMetadataRequest() {
        return this.mapParameters.get((Object)WorkerParameterName.metadataRequest);
    }

    @Override
    @JsonIgnore
    public WorkerParameters setMetadataRequest(String metadataRequest) {
        ParametersChecker.checkParameter((String)String.format(ERROR_MESSAGE, "metadataRequest"), (String[])new String[]{metadataRequest});
        this.mapParameters.put(WorkerParameterName.metadataRequest, metadataRequest);
        return this;
    }

    @Override
    @JsonIgnore
    public String getWorkerGUID() {
        return this.mapParameters.get((Object)WorkerParameterName.workerGUID);
    }

    @Override
    @JsonIgnore
    public WorkerParameters setWorkerGUID(String workerGUID) {
        ParametersChecker.checkParameter((String)String.format(ERROR_MESSAGE, "workerGUID"), (String[])new String[]{workerGUID});
        this.mapParameters.put(WorkerParameterName.workerGUID, workerGUID);
        return this;
    }

    @Override
    @JsonIgnore
    public String getProcessId() {
        return this.mapParameters.get((Object)WorkerParameterName.processId);
    }

    @Override
    @JsonIgnore
    public WorkerParameters setProcessId(String processId) {
        ParametersChecker.checkParameter((String)String.format(ERROR_MESSAGE, "processId"), (String[])new String[]{processId});
        this.mapParameters.put(WorkerParameterName.processId, processId);
        return this;
    }

    @Override
    @JsonIgnore
    public String getUrlMetadata() {
        return this.mapParameters.get((Object)WorkerParameterName.urlMetadata);
    }

    @Override
    @JsonIgnore
    public WorkerParameters setUrlMetadata(String urlMetadata) {
        ParametersChecker.checkParameter((String)String.format(ERROR_MESSAGE, "urlMetadata"), (String[])new String[]{urlMetadata});
        this.mapParameters.put(WorkerParameterName.urlMetadata, urlMetadata);
        return this;
    }

    @Override
    @JsonIgnore
    public String getUrlWorkspace() {
        return this.mapParameters.get((Object)WorkerParameterName.urlWorkspace);
    }

    @Override
    @JsonIgnore
    public WorkerParameters setUrlWorkspace(String urlWorkspace) {
        ParametersChecker.checkParameter((String)String.format(ERROR_MESSAGE, "urlWorkspace"), (String[])new String[]{urlWorkspace});
        this.mapParameters.put(WorkerParameterName.urlWorkspace, urlWorkspace);
        return this;
    }

    @Override
    @JsonIgnore
    public LogbookTypeProcess getLogbookTypeProcess() {
        return LogbookTypeProcess.valueOf((String)this.mapParameters.get((Object)WorkerParameterName.logBookTypeProcess));
    }

    @Override
    @JsonIgnore
    public WorkerParameters setLogbookTypeProcess(LogbookTypeProcess logbookTypeProcess) {
        ParametersChecker.checkParameter((String)String.format(ERROR_MESSAGE, "logBookTypeProcess"), (Object[])new Object[]{logbookTypeProcess});
        this.mapParameters.put(WorkerParameterName.logBookTypeProcess, logbookTypeProcess.toString());
        return this;
    }

    @Override
    public String getWorkflowIdentifier() {
        return this.mapParameters.get((Object)WorkerParameterName.workflowIdentifier);
    }

    @Override
    public WorkerParameters setWorkflowIdentifier(String workflowIdentifier) {
        ParametersChecker.checkParameter((String)String.format(ERROR_MESSAGE, "workflowIdentifier"), (String[])new String[]{workflowIdentifier});
        this.mapParameters.put(WorkerParameterName.workflowIdentifier, workflowIdentifier);
        return this;
    }

    @Override
    public WorkerParameters setFromParameters(WorkerParameters parameters) {
        for (WorkerParameterName item : WorkerParameterName.values()) {
            this.mapParameters.put(item, parameters.getParameterValue(item));
        }
        return this;
    }

    public String toString() {
        try {
            return JsonHandler.writeAsString(this.mapParameters);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error("Cannot convert to String via JsonHandler", (Throwable)e);
            return this.mapParameters.toString();
        }
    }

    @Override
    @JsonIgnore
    public String getRequestId() {
        return this.mapParameters.get((Object)WorkerParameterName.requestId);
    }

    @Override
    @JsonIgnore
    public WorkerParameters setRequestId(String newRequestId) {
        ParametersChecker.checkParameter((String)String.format(ERROR_MESSAGE, "newRequestId"), (String[])new String[]{newRequestId});
        this.mapParameters.put(WorkerParameterName.requestId, newRequestId);
        return this;
    }

    @Override
    @JsonIgnore
    public String getWorkflowStatusKo() {
        return this.mapParameters.get((Object)WorkerParameterName.workflowStatusKo);
    }
}

