/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.collect.common.dto.ObjectDto;
import fr.gouv.vitam.collect.common.exception.CollectInternalException;
import fr.gouv.vitam.collect.internal.core.common.CollectUnitModel;
import fr.gouv.vitam.collect.internal.core.helpers.CollectHelper;
import fr.gouv.vitam.collect.internal.core.helpers.builders.DbObjectGroupModelBuilder;
import fr.gouv.vitam.collect.internal.core.helpers.handlers.QueryHandler;
import fr.gouv.vitam.collect.internal.core.repository.MetadataRepository;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.SetAction;
import fr.gouv.vitam.common.database.builder.query.action.UpdateActionHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.format.identification.FormatIdentifier;
import fr.gouv.vitam.common.format.identification.FormatIdentifierFactory;
import fr.gouv.vitam.common.format.identification.exception.FileFormatNotFoundException;
import fr.gouv.vitam.common.format.identification.exception.FormatIdentifierBadRequestException;
import fr.gouv.vitam.common.format.identification.exception.FormatIdentifierFactoryException;
import fr.gouv.vitam.common.format.identification.exception.FormatIdentifierNotFoundException;
import fr.gouv.vitam.common.format.identification.exception.FormatIdentifierTechnicalException;
import fr.gouv.vitam.common.format.identification.model.FormatIdentifierResponse;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.administration.DataObjectVersionType;
import fr.gouv.vitam.common.model.objectgroup.DbFormatIdentificationModel;
import fr.gouv.vitam.common.model.objectgroup.DbObjectGroupModel;
import fr.gouv.vitam.common.model.objectgroup.DbQualifiersModel;
import fr.gouv.vitam.common.model.objectgroup.DbVersionsModel;
import fr.gouv.vitam.common.stream.VitamAsyncInputStreamResponse;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.input.CountingInputStream;

public class CollectService {
    public static final String UNABLE_TO_FIND_ARCHIVE_UNIT_ID = "Unable to find archiveUnit Id";
    private static final String FORMAT_IDENTIFIER_ID = "siegfried-local";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CollectService.class);
    private final MetadataRepository metadataRepository;
    private final WorkspaceClientFactory workspaceCollectClientFactory;
    private final FormatIdentifierFactory formatIdentifierFactory;

    public CollectService(MetadataRepository metadataRepository, WorkspaceClientFactory workspaceCollectClientFactory, FormatIdentifierFactory formatIdentifierFactory) {
        this.metadataRepository = metadataRepository;
        this.workspaceCollectClientFactory = workspaceCollectClientFactory;
        this.formatIdentifierFactory = formatIdentifierFactory;
    }

    public CollectUnitModel getArchiveUnitModel(String unitId) throws CollectInternalException {
        try {
            JsonNode jsonNode = this.metadataRepository.selectUnitById(unitId);
            CollectUnitModel unitModel = (CollectUnitModel)JsonHandler.getFromJsonNode((JsonNode)jsonNode, CollectUnitModel.class);
            if (unitModel == null) {
                LOGGER.error(UNABLE_TO_FIND_ARCHIVE_UNIT_ID);
                throw new CollectInternalException(UNABLE_TO_FIND_ARCHIVE_UNIT_ID);
            }
            return unitModel;
        }
        catch (CollectInternalException | InvalidParseOperationException e) {
            LOGGER.error("Error when fetching unit by id({}): {} ", (Object)unitId, (Object)e);
            throw new CollectInternalException("Error when fetching unit by id(" + unitId + ") " + (VitamException)e);
        }
    }

    public ObjectDto updateOrSaveObjectGroup(CollectUnitModel unitModel, DataObjectVersionType usage, int version, ObjectDto objectDto) throws CollectInternalException {
        try {
            objectDto.setId(GUIDFactory.newObjectGUID((int)VitamThreadUtils.getVitamSession().getTenantId()).getId());
            if (unitModel.getOg() == null) {
                this.insertNewObjectGroup(unitModel, usage, version, objectDto);
            } else {
                this.updateExistingObjectGroup(unitModel, usage, version, objectDto);
            }
            return objectDto;
        }
        catch (CollectInternalException e) {
            LOGGER.error("Error when saving Object in metadata: {}", (Throwable)e);
            throw new CollectInternalException((Throwable)e);
        }
    }

    private void updateExistingObjectGroup(CollectUnitModel unitModel, DataObjectVersionType usage, int version, ObjectDto objectDto) throws CollectInternalException {
        try {
            JsonNode objectGroup = this.metadataRepository.selectObjectGroupById(unitModel.getOg(), true);
            DbObjectGroupModel dbObjectGroupModel = (DbObjectGroupModel)JsonHandler.getFromJsonNode((JsonNode)objectGroup, DbObjectGroupModel.class);
            DbQualifiersModel qualifierModelToUpdate = CollectHelper.findQualifier(dbObjectGroupModel.getQualifiers(), usage);
            if (qualifierModelToUpdate == null) {
                CollectHelper.checkVersion(version, 1);
                this.addQualifierToObjectGroups(dbObjectGroupModel, usage, version, objectDto);
            } else {
                DbVersionsModel dbVersionsModel = CollectHelper.getObjectVersionsModel(dbObjectGroupModel, usage, version);
                if (dbVersionsModel != null) {
                    LOGGER.error("Qualifier already exist with usage {} and version {})", (Object)usage, (Object)version);
                    throw new CollectInternalException("Qualifier already exist with usage " + usage + " and version " + version);
                }
                int lastVersion = CollectHelper.getLastVersion(qualifierModelToUpdate) + 1;
                CollectHelper.checkVersion(version, lastVersion);
                this.addVersionToObjectGroups(qualifierModelToUpdate, dbObjectGroupModel, usage, lastVersion, dbObjectGroupModel.getQualifiers(), objectDto);
            }
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error("Error when updating existing Object : {}", (Throwable)e);
            throw new CollectInternalException((Throwable)e);
        }
    }

    private void insertNewObjectGroup(CollectUnitModel unitModel, DataObjectVersionType usage, int version, ObjectDto objectDto) throws CollectInternalException {
        boolean gotCreated = false;
        String gotId = null;
        try {
            CollectHelper.checkVersion(version, 1);
            DbObjectGroupModel dbObjectGroupModel = new DbObjectGroupModelBuilder().withId(GUIDFactory.newObjectGroupGUID((int)VitamThreadUtils.getVitamSession().getTenantId()).getId()).withOpi(unitModel.getOpi()).withFileInfoModel(objectDto.getFileInfo().getFileName()).withQualifiers(objectDto.getId(), objectDto.getFileInfo().getFileName(), usage, version).build();
            JsonNode jsonNode = this.metadataRepository.saveObjectGroup((ObjectNode)JsonHandler.toJsonNode((Object)dbObjectGroupModel));
            if (jsonNode == null) {
                LOGGER.error("Error when trying to insert ObjectGroup : {})", (Object)dbObjectGroupModel);
                throw new CollectInternalException("Error when trying to insert ObjectGroup : : " + dbObjectGroupModel);
            }
            gotCreated = true;
            gotId = dbObjectGroupModel.getId();
            UpdateMultiQuery multiQuery = new UpdateMultiQuery();
            multiQuery.addActions(new Action[]{UpdateActionHelper.set((String)VitamFieldsHelper.object(), (String)dbObjectGroupModel.getId())});
            multiQuery.resetRoots().addRoots(new String[]{unitModel.getId()});
            this.metadataRepository.updateUnitById(multiQuery, unitModel.getOpi(), unitModel.getId());
        }
        catch (CollectInternalException | InvalidCreateOperationException | InvalidParseOperationException e) {
            if (gotCreated) {
                this.metadataRepository.deleteObjectGroups(Collections.singletonList(gotId));
            }
            LOGGER.error("Error when saving new objectGroup in metadata : {}", e);
            throw new CollectInternalException("Error when saving new objectGroup in metadata: " + (Exception)e);
        }
    }

    private void addQualifierToObjectGroups(DbObjectGroupModel objectGroup, DataObjectVersionType usage, int version, ObjectDto objectDto) throws CollectInternalException {
        try {
            UpdateMultiQuery query = QueryHandler.getQualifiersAddMultiQuery(objectGroup, usage, version, objectDto);
            this.metadataRepository.updateObjectGroupById(query, objectGroup.getId(), objectGroup.getOpi());
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            LOGGER.error("Error when adding usage/version to existing qualifier: {}", e);
            throw new CollectInternalException("Error when adding usage/version to existing qualifier: " + (Exception)e);
        }
    }

    private void addVersionToObjectGroups(DbQualifiersModel qualifierModelToUpdate, DbObjectGroupModel objectGroup, DataObjectVersionType usage, int version, List<DbQualifiersModel> qualifiers, ObjectDto objectDto) throws CollectInternalException {
        try {
            UpdateMultiQuery query = QueryHandler.getQualifiersUpdateMultiQuery(qualifierModelToUpdate, usage, version, qualifiers, objectDto, objectGroup.getNbc());
            this.metadataRepository.updateObjectGroupById(query, objectGroup.getId(), objectGroup.getOpi());
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            LOGGER.error("Error when adding version to Object: {}", e);
            throw new CollectInternalException("Error when adding version to Object: " + (Exception)e);
        }
    }

    public DbObjectGroupModel getDbObjectGroup(CollectUnitModel unitModel) throws CollectInternalException {
        try {
            if (unitModel.getOg() == null) {
                LOGGER.debug("Cannot found any got attached to unit with id({}))", (Object)unitModel.getId());
                throw new IllegalArgumentException("Cannot found any object attached to unit with id(" + unitModel.getId() + ")");
            }
            JsonNode objectGroup = this.metadataRepository.selectObjectGroupById(unitModel.getOg(), true);
            return (DbObjectGroupModel)JsonHandler.getFromJsonNode((JsonNode)objectGroup, DbObjectGroupModel.class);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error("Error when fetching Object from metadata: {}", (Throwable)e);
            throw new CollectInternalException("Error when fetching Object from metadata: " + e);
        }
    }

    public void addBinaryInfoToQualifier(DbObjectGroupModel dbObjectGroupModel, DataObjectVersionType usage, int version, InputStream uploadedInputStream) throws CollectInternalException {
        DbQualifiersModel qualifierModelToUpdate = CollectHelper.findQualifier(dbObjectGroupModel.getQualifiers(), usage);
        if (qualifierModelToUpdate == null) {
            LOGGER.debug("Cannot found usage for object  with id({}))", (Object)dbObjectGroupModel.getId());
            throw new IllegalArgumentException("Cannot found usage for object with id(" + dbObjectGroupModel.getId() + ")");
        }
        DbVersionsModel dbVersionsModel = CollectHelper.getObjectVersionsModel(dbObjectGroupModel, usage, version);
        if (dbVersionsModel == null) {
            LOGGER.debug("Cannot found version for object  with id({}))", (Object)dbObjectGroupModel.getId());
            throw new IllegalArgumentException("Cannot found version for object with id(" + dbObjectGroupModel.getId() + ")");
        }
        File file = null;
        String extension = FilenameUtils.getExtension((String)dbVersionsModel.getFileInfoModel().getFilename()).toLowerCase();
        String fileName = dbVersionsModel.getId() + (String)(extension.equals("") ? "" : "." + extension);
        try {
            file = CollectHelper.writeToTemporaryFile(uploadedInputStream, extension);
            CountingInputStream countingInputStream = new CountingInputStream((InputStream)new FileInputStream(file));
            String digest = this.pushStreamToWorkspace(dbObjectGroupModel.getOpi(), (InputStream)countingInputStream, "Content".concat(File.separator).concat(fileName));
            Optional<FormatIdentifierResponse> formatIdentifierResponseOpt = this.detectFileFormat(file);
            if (formatIdentifierResponseOpt.isPresent()) {
                FormatIdentifierResponse formatIdentifierResponse = formatIdentifierResponseOpt.get();
                DbFormatIdentificationModel formatIdentificationModel = new DbFormatIdentificationModel();
                formatIdentificationModel.setFormatId(formatIdentifierResponse.getPuid());
                formatIdentificationModel.setMimeType(formatIdentifierResponse.getMimetype());
                formatIdentificationModel.setFormatLitteral(formatIdentifierResponse.getFormatLiteral());
                dbVersionsModel.setFormatIdentificationModel(formatIdentificationModel);
            }
            int indexQualifier = dbObjectGroupModel.getQualifiers().indexOf(qualifierModelToUpdate);
            int indexVersionsModel = qualifierModelToUpdate.getVersions().indexOf(dbVersionsModel);
            dbVersionsModel.setOpi(dbObjectGroupModel.getOpi());
            dbVersionsModel.setUri("Content" + File.separator + fileName);
            dbVersionsModel.setMessageDigest(digest);
            dbVersionsModel.setAlgorithm(DigestType.SHA512.getName());
            dbVersionsModel.setSize(countingInputStream.getByteCount());
            qualifierModelToUpdate.getVersions().set(indexVersionsModel, dbVersionsModel);
            dbObjectGroupModel.getQualifiers().set(indexQualifier, qualifierModelToUpdate);
        }
        catch (IOException e) {
            throw new CollectInternalException("Error when writing object to workspace", (Throwable)e);
        }
        finally {
            FileUtils.deleteQuietly((File)file);
        }
        try {
            HashMap<String, JsonNode> action = new HashMap<String, JsonNode>();
            action.put(BuilderToken.PROJECTIONARGS.QUALIFIERS.exactToken(), JsonHandler.toJsonNode((Object)dbObjectGroupModel.getQualifiers()));
            SetAction setQualifier = new SetAction(action);
            UpdateMultiQuery query = new UpdateMultiQuery();
            query.addHintFilter(new String[]{BuilderToken.FILTERARGS.OBJECTGROUPS.exactToken()});
            query.addActions(new Action[]{setQualifier});
            this.metadataRepository.updateObjectGroupById(query, dbObjectGroupModel.getId(), dbObjectGroupModel.getOpi());
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            throw new CollectInternalException("Error when updating existing qualifier: ", e);
        }
    }

    public String pushStreamToWorkspace(String containerName, InputStream uploadedInputStream, String fileName) throws CollectInternalException {
        String string;
        block9: {
            LOGGER.debug("Try to push stream to workspace...");
            WorkspaceClient workspaceClient = this.workspaceCollectClientFactory.getClient();
            try {
                if (!workspaceClient.isExistingContainer(containerName)) {
                    workspaceClient.createContainer(containerName);
                    workspaceClient.createFolder(containerName, "Content");
                }
                Digest digest = new Digest(VitamConfiguration.getDefaultDigestType());
                InputStream digestInputStream = digest.getDigestInputStream(uploadedInputStream);
                workspaceClient.putObject(containerName, fileName, digestInputStream);
                LOGGER.debug("Push stream to workspace finished");
                string = digest.digestHex();
                if (workspaceClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (workspaceClient != null) {
                        try {
                            workspaceClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ContentAddressableStorageException e) {
                    throw new CollectInternalException("Error when trying to push stream to workspace: ", (Throwable)e);
                }
            }
            workspaceClient.close();
        }
        return string;
    }

    public InputStream getInputStreamFromWorkspace(String containerName, String fileName) throws CollectInternalException {
        InputStream inputStream;
        block9: {
            WorkspaceClient workspaceClient = this.workspaceCollectClientFactory.getClient();
            try {
                Response response = workspaceClient.getObject(containerName, fileName);
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    throw new CollectInternalException("Cannot find stream");
                }
                inputStream = (InputStream)response.readEntity(InputStream.class);
                if (workspaceClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (workspaceClient != null) {
                        try {
                            workspaceClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ContentAddressableStorageException e) {
                    throw new CollectInternalException("Error while retrieving stream from workspace: ", (Throwable)e);
                }
            }
            workspaceClient.close();
        }
        return inputStream;
    }

    public Optional<FormatIdentifierResponse> detectFileFormat(File fileToDetect) throws CollectInternalException {
        Optional<FormatIdentifierResponse> detectedFormats = Optional.empty();
        try {
            FormatIdentifier formatIdentifier = this.formatIdentifierFactory.getFormatIdentifierFor(FORMAT_IDENTIFIER_ID);
            List formats = formatIdentifier.analysePath(fileToDetect.toPath());
            detectedFormats = Optional.ofNullable(CollectHelper.getFirstPronomFormat(formats));
        }
        catch (FileFormatNotFoundException | FormatIdentifierNotFoundException e) {
            LOGGER.warn("Can't detect format for the file  " + fileToDetect.getName(), e);
        }
        catch (FormatIdentifierBadRequestException | FormatIdentifierFactoryException | FormatIdentifierTechnicalException e) {
            throw new CollectInternalException("Technical issue on detecting format for the object : ", e);
        }
        return detectedFormats;
    }

    public Response getBinaryByUsageAndVersion(CollectUnitModel unitModel, DataObjectVersionType usage, int version) throws StorageNotFoundException, CollectInternalException {
        VitamAsyncInputStreamResponse vitamAsyncInputStreamResponse;
        block10: {
            DbObjectGroupModel dbObjectGroupModel = this.getDbObjectGroup(unitModel);
            DbVersionsModel finalversionsResponse = CollectHelper.getObjectVersionsModel(dbObjectGroupModel, usage, version);
            String filename = null;
            if (finalversionsResponse != null) {
                filename = finalversionsResponse.getUri();
            }
            if (null == filename) {
                LOGGER.error("file name not found");
                throw new CollectInternalException("file name not found");
            }
            WorkspaceClient workspaceClient = this.workspaceCollectClientFactory.getClient();
            try {
                Response binary = workspaceClient.getObject(unitModel.getOpi(), filename);
                vitamAsyncInputStreamResponse = new VitamAsyncInputStreamResponse(binary, Response.Status.OK, MediaType.APPLICATION_OCTET_STREAM_TYPE);
                if (workspaceClient == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (workspaceClient != null) {
                        try {
                            workspaceClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException e) {
                    LOGGER.error("Cannot found got with id ");
                    throw new CollectInternalException("Cannot found got with id");
                }
            }
            workspaceClient.close();
        }
        return vitamAsyncInputStreamResponse;
    }
}

