/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.repository;

import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import fr.gouv.vitam.collect.common.exception.CollectInternalException;
import fr.gouv.vitam.collect.internal.core.common.ProjectModel;
import fr.gouv.vitam.common.database.server.mongodb.BsonHelper;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;

public class ProjectRepository {
    private static final String PROJECT_COLLECTION = "Project";
    private static final String ID = "_id";
    private static final String SUBMISSION_AGENCY_IDENTIFIER = "Context.SubmissionAgencyIdentifier";
    private static final String MESSAGE_IDENTIFIER = "Context.MessageIdentifier";
    private static final String TENANT_ID = "_tenant";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ProjectRepository.class);
    private final MongoCollection<Document> projectCollection;

    @VisibleForTesting
    public ProjectRepository(MongoDbAccess mongoDbAccess, String collectionName) {
        this.projectCollection = mongoDbAccess.getMongoDatabase().getCollection(collectionName);
    }

    public ProjectRepository(MongoDbAccess mongoDbAccess) {
        this(mongoDbAccess, PROJECT_COLLECTION);
    }

    public void createProject(ProjectModel projectModel) throws CollectInternalException {
        LOGGER.debug("Project to create: {}", (Object)projectModel);
        try {
            String json = JsonHandler.writeAsString((Object)projectModel);
            this.projectCollection.insertOne((Object)Document.parse((String)json));
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error("Error when creating project : ", (Throwable)e);
            throw new CollectInternalException("Error when creating project: " + e);
        }
    }

    public void updateProject(ProjectModel projectModel) throws CollectInternalException {
        LOGGER.debug("Project to update: {}", (Object)projectModel);
        try {
            String json = JsonHandler.writeAsString((Object)projectModel);
            Bson filter = Filters.eq((String)ID, (Object)projectModel.getId());
            Document update = Document.parse((String)json);
            update.remove((Object)ID);
            Document updateOperation = new Document("$set", (Object)update);
            this.projectCollection.updateOne(filter, (Bson)updateOperation);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error("Error when updating project: ", (Throwable)e);
            throw new CollectInternalException("Error when updating project: " + e.getMessage());
        }
    }

    public Optional<ProjectModel> findProjectById(String id) throws CollectInternalException {
        LOGGER.debug("Project id to find : {}", (Object)id);
        try {
            Integer tenantId = VitamThreadUtils.getVitamSession().getTenantId();
            Bson query = Filters.and((Bson[])new Bson[]{Filters.eq((String)ID, (Object)id), Filters.eq((String)TENANT_ID, (Object)tenantId)});
            Document first = (Document)this.projectCollection.find(query).first();
            if (first == null) {
                return Optional.empty();
            }
            return Optional.of((ProjectModel)BsonHelper.fromDocumentToObject((Document)first, ProjectModel.class));
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error("Error when searching project by id: ", (Throwable)e);
            throw new CollectInternalException("Error when searching project by id: " + e);
        }
    }

    public List<ProjectModel> findProjectsByTenant(Integer tenant) throws CollectInternalException {
        LOGGER.debug("Project tenant to find : {}", (Object)tenant);
        try {
            ArrayList<ProjectModel> listProjects = new ArrayList<ProjectModel>();
            try (MongoCursor projectsCursor = this.projectCollection.find(Filters.eq((String)TENANT_ID, (Object)tenant)).cursor();){
                while (projectsCursor.hasNext()) {
                    Document doc = (Document)projectsCursor.next();
                    listProjects.add((ProjectModel)BsonHelper.fromDocumentToObject((Document)doc, ProjectModel.class));
                }
            }
            return listProjects;
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error("Error when fetching project: ", (Throwable)e);
            throw new CollectInternalException("Error when fetching project : " + e);
        }
    }

    public void deleteProject(String id) {
        LOGGER.debug("Project to delete Id: {}", (Object)id);
        this.projectCollection.deleteOne(Filters.eq((String)ID, (Object)id));
        LOGGER.debug("Project deleted Id: {}", (Object)id);
    }

    public List<ProjectModel> searchProject(String searchValue, int tenant) throws CollectInternalException {
        List<String> keys = List.of(ID, SUBMISSION_AGENCY_IDENTIFIER, MESSAGE_IDENTIFIER);
        try {
            ArrayList<ProjectModel> listProjects = new ArrayList<ProjectModel>();
            List filters = keys.stream().map(key -> {
                if (ID.equals(key)) {
                    return Filters.eq((String)key, (Object)searchValue);
                }
                return Filters.regex((String)key, (String)Pattern.quote(searchValue), (String)"i");
            }).collect(Collectors.toList());
            try (MongoCursor projectsCursor = this.projectCollection.find(Filters.and((Bson[])new Bson[]{Filters.or(filters), Filters.eq((String)TENANT_ID, (Object)tenant)})).cursor();){
                while (projectsCursor.hasNext()) {
                    Document doc = (Document)projectsCursor.next();
                    listProjects.add((ProjectModel)BsonHelper.fromDocumentToObject((Document)doc, ProjectModel.class));
                }
            }
            return listProjects;
        }
        catch (InvalidParseOperationException e) {
            throw new CollectInternalException("Error when fetching projects : " + e);
        }
    }
}

