/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.csv;

import fr.gouv.vitam.collect.internal.core.csv.CsvMetadataUtils;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class FieldNameValidationUtils {
    public static final int MAX_FIELD_NAME_LENGTH = 100;
    private static final Set<Character> RESERVED_CHARACTERS = "'\"`,;:\u00b0$\u00a7&# .*+=/|\\(){}[]@~^!?<>%".chars().mapToObj(c -> Character.valueOf((char)c)).collect(Collectors.toSet());

    private FieldNameValidationUtils() {
    }

    public static void validateRegularVitamFieldName(String fieldName) throws IllegalArgumentException {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{fieldName})) {
            throw new IllegalArgumentException("Empty or blank field name");
        }
        for (char c : fieldName.toCharArray()) {
            if (!Character.isISOControl(c) && Character.isDefined(c) && !RESERVED_CHARACTERS.contains(Character.valueOf(c))) continue;
            throw new IllegalArgumentException("Reserved / illegal characters");
        }
        if (fieldName.length() > 100) {
            throw new IllegalArgumentException("Field name too long");
        }
        if (fieldName.startsWith("_") || fieldName.startsWith("-")) {
            throw new IllegalArgumentException("Field name cannot start with '_' or '-'");
        }
        if (CsvMetadataUtils.matchesPattern(fieldName, CsvMetadataUtils.STARTS_WITH_DIGIT_PATTERN)) {
            throw new IllegalArgumentException("Field name cannot start with a digit");
        }
    }
}

