/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.csv;

import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.collect.internal.core.common.CollectJsonMetadataLine;
import fr.gouv.vitam.collect.internal.core.csv.CsvErrorAccumulator;
import fr.gouv.vitam.collect.internal.core.csv.CsvToJsonConverter;
import fr.gouv.vitam.collect.internal.core.csv.SedaSchemaInfoResolver;
import fr.gouv.vitam.collect.internal.core.exceptions.CollectInvalidCsvFormatException;
import fr.gouv.vitam.worker.core.distribution.JsonLineWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class CsvHelper {
    private static final int MAX_PATH_LENGTH = 255;

    private CsvHelper() {
    }

    public static void convertCsvToJsonlMetadataFile(SedaSchemaInfoResolver sedaSchemaInfoResolver, InputStream is, File metadataFile) throws IOException, CollectInvalidCsvFormatException {
        try (CSVParser parser = CsvHelper.createParser(is);
             JsonLineWriter writer = new JsonLineWriter((OutputStream)new FileOutputStream(metadataFile, true), true);){
            List headerNames = parser.getHeaderNames();
            CsvToJsonConverter csvToJsonConverter = new CsvToJsonConverter(sedaSchemaInfoResolver, headerNames);
            try (CsvErrorAccumulator csvErrorAccumulator = new CsvErrorAccumulator();){
                for (CSVRecord record : parser) {
                    ObjectNode unitJson;
                    long csvRecordNumberIncludingHeader = record.getRecordNumber() + 1L;
                    if (!record.isConsistent()) {
                        csvErrorAccumulator.report("Invalid CSV record at line " + csvRecordNumberIncludingHeader + ": Nb columns (" + record.size() + ") must match nb headers (" + headerNames.size() + ")");
                        continue;
                    }
                    String uploadPath = FilenameUtils.separatorsToUnix((String)record.get("File"));
                    if (StringUtils.isBlank((CharSequence)uploadPath)) {
                        csvErrorAccumulator.report("Invalid CSV record at line " + csvRecordNumberIncludingHeader + ": Empty File");
                        continue;
                    }
                    try {
                        unitJson = csvToJsonConverter.convertCsvRecordToJson(record);
                    }
                    catch (CollectInvalidCsvFormatException e) {
                        csvErrorAccumulator.report(String.format("Invalid CSV record at line %d (File=\"%s\"): %s", csvRecordNumberIncludingHeader, CsvHelper.sanitizeStringForLog(uploadPath, 255), e.getMessage()));
                        continue;
                    }
                    writer.addEntry((Object)new CollectJsonMetadataLine().setFile(uploadPath).setUnitContent(unitJson));
                }
            }
        }
    }

    public static CSVParser createParser(InputStream is) throws IOException {
        InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);
        return new CSVParser((Reader)reader, CSVFormat.Builder.create((CSVFormat)CSVFormat.DEFAULT).setHeader(new String[0]).setTrim(true).setIgnoreEmptyLines(false).setDelimiter(';').build());
    }

    public static String sanitizeStringForLog(String uploadPath, int maxLength) {
        return StringUtils.abbreviate((String)StringEscapeUtils.escapeJava((String)uploadPath), (int)maxLength);
    }
}

