/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.csv;

import fr.gouv.vitam.collect.internal.core.csv.CsvMetadataUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class CsvHeaderFieldNameIterable
implements Iterable<FieldEntry> {
    private final String[] fieldNames;

    public CsvHeaderFieldNameIterable(String headerName) {
        this.fieldNames = StringUtils.splitPreserveAllTokens((String)headerName, (String)".");
    }

    @Override
    public Iterator<FieldEntry> iterator() {
        return new Iterator<FieldEntry>(){
            private int index = 0;
            private String simpleSedaPath = null;
            private String fullSedaPath = null;

            @Override
            public boolean hasNext() {
                return this.index < CsvHeaderFieldNameIterable.this.fieldNames.length;
            }

            @Override
            public FieldEntry next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String fieldName = CsvHeaderFieldNameIterable.this.fieldNames[this.index];
                String parentSimpleSedaPath = this.simpleSedaPath;
                this.simpleSedaPath = CsvMetadataUtils.buildPath(this.simpleSedaPath, fieldName);
                String parentFullSedaPath = this.fullSedaPath;
                String fullSedaPathWithoutLastArrayIndex = this.fullSedaPath = CsvMetadataUtils.buildPath(this.fullSedaPath, fieldName);
                Integer arrayIndex = null;
                if (this.index + 1 < CsvHeaderFieldNameIterable.this.fieldNames.length && CsvMetadataUtils.matchesPattern(CsvHeaderFieldNameIterable.this.fieldNames[this.index + 1], CsvMetadataUtils.ARRAY_INDEX_PATTERN)) {
                    String arrayIndexStr = CsvHeaderFieldNameIterable.this.fieldNames[this.index + 1];
                    arrayIndex = Integer.valueOf(arrayIndexStr);
                    this.fullSedaPath = CsvMetadataUtils.buildPath(this.fullSedaPath, arrayIndexStr);
                    ++this.index;
                }
                ++this.index;
                boolean isDeclaredAsObject = this.index < CsvHeaderFieldNameIterable.this.fieldNames.length;
                return new FieldEntry(fieldName, arrayIndex, isDeclaredAsObject, this.simpleSedaPath, this.fullSedaPath, fullSedaPathWithoutLastArrayIndex, parentFullSedaPath, parentSimpleSedaPath);
            }
        };
    }

    public final class FieldEntry {
        private final String sedaFieldName;
        private final Integer arrayIndex;
        private final boolean isDeclaredAsObject;
        private final String simpleSedaPath;
        private final String fullSedaPath;
        private final String fullSedaPathWithoutLastArrayIndex;
        private final String parentFullSedaPath;
        private final String parentSimpleSedaPath;

        public FieldEntry(String sedaFieldName, Integer arrayIndex, boolean isDeclaredAsObject, String simpleSedaPath, String fullSedaPath, String fullSedaPathWithoutLastArrayIndex, String parentFullSedaPath, String parentSimpleSedaPath) {
            this.sedaFieldName = sedaFieldName;
            this.arrayIndex = arrayIndex;
            this.isDeclaredAsObject = isDeclaredAsObject;
            this.simpleSedaPath = simpleSedaPath;
            this.fullSedaPath = fullSedaPath;
            this.fullSedaPathWithoutLastArrayIndex = fullSedaPathWithoutLastArrayIndex;
            this.parentFullSedaPath = parentFullSedaPath;
            this.parentSimpleSedaPath = parentSimpleSedaPath;
        }

        public boolean isDeclaredAsArray() {
            return this.arrayIndex != null;
        }

        public String sedaFieldName() {
            return this.sedaFieldName;
        }

        public Integer arrayIndex() {
            return this.arrayIndex;
        }

        public boolean isDeclaredAsObject() {
            return this.isDeclaredAsObject;
        }

        public String simpleSedaPath() {
            return this.simpleSedaPath;
        }

        public String fullSedaPath() {
            return this.fullSedaPath;
        }

        public String fullSedaPathWithoutLastArrayIndex() {
            return this.fullSedaPathWithoutLastArrayIndex;
        }

        public String parentFullSedaPath() {
            return this.parentFullSedaPath;
        }

        public String parentSimpleSedaPath() {
            return this.parentSimpleSedaPath;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            FieldEntry that = (FieldEntry)obj;
            return Objects.equals(this.sedaFieldName, that.sedaFieldName) && Objects.equals(this.arrayIndex, that.arrayIndex) && this.isDeclaredAsObject == that.isDeclaredAsObject && Objects.equals(this.simpleSedaPath, that.simpleSedaPath) && Objects.equals(this.fullSedaPath, that.fullSedaPath) && Objects.equals(this.fullSedaPathWithoutLastArrayIndex, that.fullSedaPathWithoutLastArrayIndex) && Objects.equals(this.parentFullSedaPath, that.parentFullSedaPath) && Objects.equals(this.parentSimpleSedaPath, that.parentSimpleSedaPath);
        }

        public int hashCode() {
            return Objects.hash(this.sedaFieldName, this.arrayIndex, this.isDeclaredAsObject, this.simpleSedaPath, this.fullSedaPath, this.fullSedaPathWithoutLastArrayIndex, this.parentFullSedaPath, this.parentSimpleSedaPath);
        }

        public String toString() {
            return "FieldEntry[sedaFieldName=" + this.sedaFieldName + ", arrayIndex=" + this.arrayIndex + ", isDeclaredAsObject=" + this.isDeclaredAsObject + ", simpleSedaPath=" + this.simpleSedaPath + ", fullSedaPath=" + this.fullSedaPath + ", fullSedaPathWithoutLastArrayIndex=" + this.fullSedaPathWithoutLastArrayIndex + ", parentFullSedaPath=" + this.parentFullSedaPath + ", parentSimpleSedaPath=" + this.parentSimpleSedaPath + "]";
        }
    }
}

