/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.client;

import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.iterables.BulkBufferingEntryIterator;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.OfferLog;
import fr.gouv.vitam.storage.engine.common.model.Order;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class StorageClientOfferLogIterator
extends BulkBufferingEntryIterator<OfferLog> {
    private final String strategyId;
    private final String offerId;
    private final Order order;
    private final DataCategory dataCategory;
    private final StorageClientFactory storageClientFactory;
    private final int chunkSize;
    private Long lastOffset;

    public StorageClientOfferLogIterator(StorageClientFactory storageClientFactory, String strategyId, String offerId, Order order, DataCategory dataCategory, int chunkSize, Long startOffset) {
        super(chunkSize);
        this.strategyId = strategyId;
        this.offerId = offerId;
        this.order = order;
        this.dataCategory = dataCategory;
        this.storageClientFactory = storageClientFactory;
        this.chunkSize = chunkSize;
        this.lastOffset = startOffset;
    }

    protected List<OfferLog> loadNextChunk(int chunkSize) {
        List list;
        block14: {
            StorageClient storageClient = this.storageClientFactory.getClient();
            try {
                RequestResponse<OfferLog> response = storageClient.getOfferLogs(this.strategyId, this.offerId, this.dataCategory, this.lastOffset, this.chunkSize, this.order);
                if (!response.isOk()) {
                    throw new VitamRuntimeException("Could not list offer log");
                }
                List buffer = ((RequestResponseOK)response).getResults();
                if (!CollectionUtils.isEmpty((Collection)buffer)) {
                    switch (this.order) {
                        case ASC: {
                            this.lastOffset = ((OfferLog)buffer.get(buffer.size() - 1)).getSequence() + 1L;
                            break;
                        }
                        case DESC: {
                            this.lastOffset = ((OfferLog)buffer.get(buffer.size() - 1)).getSequence() - 1L;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Invalid order " + this.order);
                        }
                    }
                }
                list = buffer;
                if (storageClient == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (storageClient != null) {
                        try {
                            storageClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StorageServerClientException e) {
                    throw new VitamRuntimeException((Throwable)((Object)e));
                }
            }
            storageClient.close();
        }
        return list;
    }
}

