/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.step;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.FileUtil;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.SecurityProfileModel;
import fr.gouv.vitam.functionaltest.cucumber.step.CommonStep;
import fr.gouv.vitam.functionaltest.cucumber.step.World;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;

public class SecurityProfileStep
extends CommonStep {
    private String fileName;
    private String securityProfileName;

    public SecurityProfileStep(World world) {
        super(world);
    }

    @Given(value="^un profile de s\u00e9curit\u00e9 nomm\u00e9 (.*)$")
    public void a_security_profile_with_file_name(String fileName) {
        this.fileName = fileName;
    }

    @Then(value="^j'importe ce profile de s\u00e9curit\u00e9 en succ\u00e8s")
    public void success_upload_security_profile() throws IOException, VitamClientException, AccessExternalClientException, InvalidParseOperationException {
        Path securityProfile = Paths.get(this.world.getBaseDirectory(), this.fileName);
        RequestResponse response = this.world.getAdminClient().createSecurityProfiles(new VitamContext(Integer.valueOf(this.world.getTenantId())).setApplicationSessionId(this.world.getApplicationSessionId()), Files.newInputStream(securityProfile, StandardOpenOption.READ), this.fileName);
        String operationId = response.getHeaderString("X-Request-Id");
        this.world.setOperationId(operationId);
        Assertions.assertThat((int)response.getHttpCode()).isEqualTo(Response.Status.CREATED.getStatusCode());
    }

    @Then(value="^j'importe ce profile de s\u00e9curit\u00e9 en \u00e9chec")
    public void fail_upload_security_profile() throws VitamClientException, IOException, AccessExternalClientException, InvalidParseOperationException {
        Path securityProfile = Paths.get(this.world.getBaseDirectory(), this.fileName);
        RequestResponse response = this.world.getAdminClient().createSecurityProfiles(new VitamContext(Integer.valueOf(this.world.getTenantId())).setApplicationSessionId(this.world.getApplicationSessionId()), Files.newInputStream(securityProfile, StandardOpenOption.READ), this.fileName);
        String operationId = response.getHeaderString("X-Request-Id");
        this.world.setOperationId(operationId);
        Assertions.assertThat((int)response.getHttpCode()).isEqualTo(Response.Status.BAD_REQUEST.getStatusCode());
    }

    @Given(value="^un profile de s\u00e9curit\u00e9 ayant pour nom (.*)$")
    public void a_security_profile_name(String securityOperationName) {
        this.securityProfileName = securityOperationName;
    }

    @When(value="^je modifie le profile de s\u00e9curit\u00e9 avec le fichier de requ\u00eate suivant (.*) le statut de la requ\u00eate est (.*)$")
    public void update_security_profile_by_query(String queryFilename, Integer statusCode) throws VitamClientException, IOException, InvalidParseOperationException, InvalidCreateOperationException {
        String securityProfileIdentifier = this.getSecurityProfileByName().getIdentifier();
        Path queryFile = Paths.get(this.world.getBaseDirectory(), queryFilename);
        String query = FileUtil.readFile((File)queryFile.toFile());
        JsonNode queryDsl = JsonHandler.getFromString((String)query);
        RequestResponse requestResponse = this.world.getAdminClient().updateSecurityProfile(new VitamContext(Integer.valueOf(this.world.getTenantId())).setApplicationSessionId(this.world.getApplicationSessionId()), securityProfileIdentifier, queryDsl);
        String operationId = requestResponse.getHeaderString("X-Request-Id");
        this.world.setOperationId(operationId);
        Assertions.assertThat((Integer)statusCode).isEqualTo(requestResponse.getStatus());
    }

    @Then(value="^le profile de s\u00e9curit\u00e9 contient la permission (.*)$")
    public void has_permission(String permission) throws AccessExternalClientException, InvalidParseOperationException, VitamClientException, InvalidCreateOperationException {
        SecurityProfileModel securityProfileModel = this.getSecurityProfileByName();
        Assertions.assertThat((Collection)securityProfileModel.getPermissions()).contains((Object[])new String[]{permission});
    }

    @Then(value="^le profile de s\u00e9curit\u00e9 ne contient pas la permission (.*)$")
    public void has_not_permission(String permission) throws AccessExternalClientException, InvalidParseOperationException, VitamClientException, InvalidCreateOperationException {
        SecurityProfileModel securityProfileModel = this.getSecurityProfileByName();
        Assertions.assertThat((Collection)securityProfileModel.getPermissions()).doesNotContain((Object[])new String[]{permission});
    }

    @Then(value="^le profile de s\u00e9curit\u00e9 a toutes les permissions$")
    public void has_full_access() throws InvalidParseOperationException, VitamClientException, InvalidCreateOperationException {
        SecurityProfileModel securityProfileModel = this.getSecurityProfileByName();
        Assertions.assertThat((Boolean)securityProfileModel.getFullAccess()).isTrue();
    }

    private SecurityProfileModel getSecurityProfileByName() throws InvalidCreateOperationException, VitamClientException {
        Select select = new Select();
        select.setQuery((Query)QueryHelper.eq((String)"Name", (String)this.securityProfileName));
        ObjectNode query = select.getFinalSelect();
        RequestResponse requestResponse = this.world.getAdminClient().findSecurityProfiles(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(null).setApplicationSessionId(this.world.getApplicationSessionId()), (JsonNode)query);
        Assertions.assertThat((boolean)requestResponse.isOk()).isTrue();
        Assertions.assertThat((int)((RequestResponseOK)requestResponse).getResults().size()).isEqualTo(1);
        SecurityProfileModel securityProfileModel = (SecurityProfileModel)((RequestResponseOK)requestResponse).getFirstResult();
        Assertions.assertThat((String)securityProfileModel.getName()).isEqualTo(this.securityProfileName);
        return securityProfileModel;
    }
}

