/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.step;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.schema.SchemaOrigin;
import fr.gouv.vitam.common.model.administration.schema.SchemaResponse;
import fr.gouv.vitam.functionaltest.cucumber.step.CommonStep;
import fr.gouv.vitam.functionaltest.cucumber.step.World;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;

public class SchemaStep
extends CommonStep {
    private Path fileName;
    private List<SchemaResponse> unitSchemas;
    private SchemaResponse unitSchema;

    public SchemaStep(World world) {
        super(world);
    }

    @Given(value="^un fichier schema nomm\u00e9 (.*)$")
    public void setFileName(String fileName) {
        this.fileName = Paths.get(this.world.getBaseDirectory(), fileName);
    }

    @When(value="^j'importe le schema externe$")
    public void importExternalSchema() throws InvalidParseOperationException, AccessExternalClientException, IOException {
        try (InputStream inputStream = Files.newInputStream(this.fileName, StandardOpenOption.READ);){
            VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId()));
            vitamContext.setApplicationSessionId(this.world.getApplicationSessionId());
            RequestResponse requestResponse = this.world.getAdminClient().importUnitExternalSchema(vitamContext, inputStream);
            String operationId = requestResponse.getHeaderString("X-Request-Id");
            this.world.setOperationId(operationId);
            String httpCode = String.valueOf(requestResponse.getHttpCode());
            ObjectNode responseCode = JsonHandler.createObjectNode();
            responseCode.put("Code", httpCode);
            ArrayList<JsonNode> result = new ArrayList<JsonNode>();
            result.add((JsonNode)responseCode);
            this.world.setResults(result);
        }
    }

    @When(value="^je recup\u00e8re le schema$")
    public void searchSchemaByPath() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId()));
        vitamContext.setApplicationSessionId(this.world.getApplicationSessionId());
        RequestResponse requestResponse = this.world.getAdminClient().getUnitSchema(vitamContext);
        Assertions.assertThat((boolean)requestResponse.isOk()).isTrue();
        this.unitSchemas = ((RequestResponseOK)requestResponse).getResults();
    }

    @Then(value="^le schema doit contenir le path (.*)$")
    public void schema_should_contains_path(String path) {
        this.doSearchSchema(path);
    }

    @When(value="^je cherche le schema ayant le path (.*)$")
    public void search_schema(String path) {
        this.unitSchema = this.doSearchSchema(path);
    }

    private SchemaResponse doSearchSchema(String path) {
        Assertions.assertThat(this.unitSchemas).isNotEmpty();
        Optional<SchemaResponse> schemaResponse = this.unitSchemas.stream().filter(unitSchema -> SchemaOrigin.EXTERNAL.equals((Object)unitSchema.getOrigin()) && path.equals(unitSchema.getPath())).findFirst();
        Assertions.assertThat(schemaResponse).isPresent();
        return schemaResponse.get();
    }

    @Then(value="^le type d\u00e9taill\u00e9 du schema est (.*)$")
    public void schema_should_have_type_detail(String typeDetail) {
        Assertions.assertThat((String)this.unitSchema.getTypeDetail().name()).isEqualTo(typeDetail);
    }

    @Then(value="^la taille de la cha\u00eene de caract\u00e8re du schema est (.*)$")
    public void schema_should_have_string_size(String stringSize) {
        if ("ind\u00e9finie".equals(stringSize)) {
            Assertions.assertThat((Comparable)this.unitSchema.getStringSize()).isNull();
        } else {
            Assertions.assertThat((String)this.unitSchema.getStringSize().name()).isEqualTo(stringSize);
        }
    }

    @Then(value="^je supprime le schema dont le path est (.*)$")
    public void schema_should_be_deleted(String path) throws InvalidParseOperationException, AccessExternalClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId()));
        vitamContext.setApplicationSessionId(this.world.getApplicationSessionId());
        RequestResponse requestResponse = this.world.getAdminClient().deleteUnitExternalSchemas(vitamContext, Collections.singletonList(path));
        String httpCode = String.valueOf(requestResponse.getHttpCode());
        ObjectNode responseCode = JsonHandler.createObjectNode();
        responseCode.put("Code", httpCode);
        ArrayList<JsonNode> result = new ArrayList<JsonNode>();
        result.add((JsonNode)responseCode);
        this.world.setResults(result);
    }
}

