/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.step;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.functionaltest.cucumber.step.CommonStep;
import fr.gouv.vitam.functionaltest.cucumber.step.World;
import io.cucumber.datatable.DataTable;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;

public class ProfileStep
extends CommonStep {
    private String fileName;
    private JsonNode model;

    public ProfileStep(World world) {
        super(world);
    }

    @Given(value="^un profil nomm\u00e9 (.*)$")
    public void a_profile_named(String fileName) {
        this.fileName = fileName;
    }

    @When(value="^j'importe le profile d'archivage$")
    public void create_profile() throws AccessExternalClientException, IOException, InvalidParseOperationException {
        this.create_profile(true);
    }

    @When(value="^j'importe le profile d'archivage sans \u00e9chec$")
    public void create_profile_ignoring_failure() throws AccessExternalClientException, IOException, InvalidParseOperationException {
        this.create_profile(null);
    }

    @When(value="^j'importe le profile d'archivage incorrect$")
    public void create_profile_with_expected_failure() throws AccessExternalClientException, IOException, InvalidParseOperationException {
        this.create_profile(false);
    }

    private void create_profile(Boolean expectedSuccessStatus) throws InvalidParseOperationException, IOException, AccessExternalClientException {
        Path profil = Paths.get(this.world.getBaseDirectory(), this.fileName);
        RequestResponse response = this.world.getAdminClient().createProfiles(new VitamContext(Integer.valueOf(this.world.getTenantId())).setApplicationSessionId(this.world.getApplicationSessionId()), Files.newInputStream(profil, StandardOpenOption.READ));
        String httpCode = String.valueOf(response.getHttpCode());
        ObjectNode responseCode = JsonHandler.createObjectNode();
        responseCode.put("Code", httpCode);
        ArrayList<JsonNode> result = new ArrayList<JsonNode>();
        result.add((JsonNode)responseCode);
        this.world.setResults(result);
        String operationId = response.getHeaderString("X-Request-Id");
        this.world.setOperationId(operationId);
        if (expectedSuccessStatus != null) {
            if (expectedSuccessStatus.booleanValue()) {
                Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.CREATED.getStatusCode());
                RequestResponseOK res = (RequestResponseOK)response;
                Object o = res.getResults().stream().findFirst().get();
                this.model = (JsonNode)o;
            } else {
                Assertions.assertThat((int)response.getStatus()).isNotEqualTo(Response.Status.CREATED.getStatusCode());
            }
        }
    }

    @When(value="^je rattache un ficher \u00e0 ce profil d'archivage$")
    public void import_profile() throws InvalidParseOperationException, IOException, AccessExternalClientException {
        this.import_profile(true);
    }

    @When(value="^je rattache un ficher \u00e0 ce profil d'archivage sans \u00e9chec$")
    public void import_profile_ignoring_failure() throws InvalidParseOperationException, IOException, AccessExternalClientException {
        this.import_profile(null);
    }

    @When(value="^je rattache un ficher incorrect \u00e0 ce profil d'archivage")
    public void import_profile_with_expected_failure() throws InvalidParseOperationException, IOException, AccessExternalClientException {
        this.import_profile(false);
    }

    private void import_profile(Boolean expectedSuccessStatus) throws InvalidParseOperationException, IOException, AccessExternalClientException {
        Path profile = Paths.get(this.world.getBaseDirectory(), this.fileName);
        RequestResponse response = null;
        if (this.model != null && this.model.get("Identifier") != null) {
            response = this.world.getAdminClient().createProfileFile(new VitamContext(Integer.valueOf(this.world.getTenantId())).setApplicationSessionId(this.world.getApplicationSessionId()), this.model.get("Identifier").asText(), Files.newInputStream(profile, StandardOpenOption.READ));
        }
        if (expectedSuccessStatus != null) {
            Assertions.assertThat(response).isNotNull();
            Assertions.assertThat((boolean)response.isOk()).isEqualTo((Object)expectedSuccessStatus);
        }
    }

    @When(value="^je cherche un profil nomm\u00e9 (.*)")
    public void search_profiles(String name) throws AccessExternalClientException, InvalidParseOperationException, InvalidCreateOperationException, VitamClientException {
        Select select = new Select();
        select.setQuery((Query)QueryHelper.match((String)"Name", (String)name));
        ObjectNode query = select.getFinalSelect();
        RequestResponse requestResponse = this.world.getAdminClient().findProfiles(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(null).setApplicationSessionId(this.world.getApplicationSessionId()), (JsonNode)query);
        if (requestResponse.isOk()) {
            this.model = (JsonNode)((RequestResponseOK)requestResponse).getResultsAsJsonNodes().get(0);
        }
    }

    @Then(value="^le profil existe$")
    public void profile_found() {
        Assertions.assertThat((Iterable)this.model).isNotNull();
    }

    @Then(value="^le profil n'existe pas$")
    public void profile_not_found() {
        Assertions.assertThat((Iterable)this.model).isNull();
    }

    @Then(value="^les m\u00e9tadonn\u00e9es du profil sont$")
    public void metadata_are(DataTable dataTable) throws Throwable {
        List raws = dataTable.cells();
        for (List raw : raws) {
            String index = (String)raw.get(0);
            String value = (String)raw.get(1);
            Assertions.assertThat((String)this.model.get(index).asText()).contains(new CharSequence[]{value});
        }
    }
}

