/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.step;

import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functionaltest.cucumber.step.CommonStep;
import fr.gouv.vitam.functionaltest.cucumber.step.World;
import fr.gouv.vitam.logbook.common.model.coherence.LogbookCheckResult;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.util.Collection;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;

public class LogbookCheckConsistencyStep
extends CommonStep {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookCheckConsistencyStep.class);
    public static final String INTERNAL_SERVER_ERROR = "Internal Server Error";
    private LogbookCheckResult result;

    public LogbookCheckConsistencyStep(World world) {
        super(world);
        new VitamContext(Integer.valueOf(world.getTenantId()));
    }

    @When(value="^je lance le test de coh\u00e9rence des journaux")
    public void logbook_consistency_check() {
        this.runInVitamThread(() -> {
            try {
                VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(this.world.getTenantId()));
                this.result = this.world.getLogbookOperationsClient().checkLogbookCoherence();
                ((ObjectAssert)Assertions.assertThat((Object)this.result).as("Le rapport du test de coh\u00e9rence des journaux n'est pas disponible", new Object[0])).isNotNull();
            }
            catch (VitamException e) {
                LOGGER.error(INTERNAL_SERVER_ERROR);
                Assertions.fail((String)INTERNAL_SERVER_ERROR);
            }
        });
    }

    @Then(value="^je verifie que le rapport du test de coh\u00e9rence des journaux ne contient pas d'erreur")
    public void the_logbook_consistency_check_report_does_not_contain_errors() throws StorageException, StorageServerClientException, InvalidParseOperationException {
        ((ObjectAssert)Assertions.assertThat((Object)this.result).as("Le rapport du test de coh\u00e9rence des journaux n'est pas disponible", new Object[0])).isNotNull();
        String resultAsString = JsonHandler.prettyPrint((Object)JsonHandler.toJsonNode((Object)this.result));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)this.result.getCheckErrors()).as("Le rapport du test de coh\u00e9rence des journaux contient une ou plusieurs erreurs : " + resultAsString, new Object[0])).isNullOrEmpty();
    }
}

