/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.step;

import fr.gouv.vitam.access.external.client.OperationStatusClient;
import fr.gouv.vitam.access.external.client.VitamPoolingClient;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidGuidOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ProcessAction;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.logbook.LogbookEvent;
import fr.gouv.vitam.common.model.logbook.LogbookEventOperation;
import fr.gouv.vitam.functionaltest.cucumber.step.CommonStep;
import fr.gouv.vitam.functionaltest.cucumber.step.World;
import fr.gouv.vitam.logbook.common.parameters.Contexts;
import fr.gouv.vitam.tools.SipTool;
import io.cucumber.java.After;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.When;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;

public class IngestStep
extends CommonStep {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(IngestStep.class);
    public static final String ID = "ID";
    public static final String _ID = "#id";
    private static boolean deleteSip = false;
    private static boolean attachMode = false;

    public IngestStep(World world) {
        super(world);
    }

    @Given(value="^un fichier SIP nomm\u00e9 (.*)$")
    public void a_sip_named(String fileName) {
        this.world.setSipFile(Paths.get(this.world.getBaseDirectory(), fileName));
    }

    @When(value="^je t\u00e9l\u00e9charge le SIP")
    public void upload_this_sip() throws VitamException, IOException {
        try (InputStream inputStream = Files.newInputStream(this.world.getSipFile(), StandardOpenOption.READ);){
            RequestResponse response = this.world.getIngestClient().ingest(new VitamContext(Integer.valueOf(this.world.getTenantId())).setApplicationSessionId(this.world.getApplicationSessionId()), inputStream, Contexts.DEFAULT_WORKFLOW.name(), ProcessAction.RESUME.name());
            String operationId = response.getHeaderString("X-Request-Id");
            this.world.setOperationId(operationId);
            VitamPoolingClient vitamPoolingClient = new VitamPoolingClient((OperationStatusClient)this.world.getAdminClient());
            boolean process_timeout = vitamPoolingClient.wait(this.world.getTenantId(), operationId, ProcessState.COMPLETED, 1800, 1000L, TimeUnit.MILLISECONDS);
            if (!process_timeout) {
                Assertions.fail((String)("Sip processing not finished : operation (" + operationId + "). Timeout exceeded."));
            }
            ((AbstractStringAssert)Assertions.assertThat((String)operationId).as(String.format("%s not found for request", "X-Request-Id"), new Object[0])).isNotNull();
        }
    }

    @When(value="^je t\u00e9l\u00e9charge le plan")
    public void upload_this_plan() throws IOException, VitamException {
        try (InputStream inputStream = Files.newInputStream(this.world.getSipFile(), StandardOpenOption.READ);){
            RequestResponse response = this.world.getIngestClient().ingest(new VitamContext(Integer.valueOf(this.world.getTenantId())).setApplicationSessionId(this.world.getApplicationSessionId()), inputStream, Contexts.FILING_SCHEME.name(), ProcessAction.RESUME.name());
            String operationId = response.getHeaderString("X-Request-Id");
            this.world.setOperationId(operationId);
            VitamPoolingClient vitamPoolingClient = new VitamPoolingClient((OperationStatusClient)this.world.getAdminClient());
            boolean process_timeout = vitamPoolingClient.wait(this.world.getTenantId(), operationId, ProcessState.COMPLETED, 200, 1000L, TimeUnit.MILLISECONDS);
            if (!process_timeout) {
                Assertions.fail((String)("Sip processing not finished : operation (" + operationId + "). Timeout exceeded."));
            }
            ((AbstractStringAssert)Assertions.assertThat((String)operationId).as(String.format("%s not found for request", "X-Request-Id"), new Object[0])).isNotNull();
        }
        if (attachMode) {
            deleteSip = true;
        }
    }

    @When(value="^je t\u00e9l\u00e9charge l'arbre")
    public void upload_this_tree() throws IOException, VitamException {
        try (InputStream inputStream = Files.newInputStream(this.world.getSipFile(), StandardOpenOption.READ);){
            RequestResponse response = this.world.getIngestClient().ingest(new VitamContext(Integer.valueOf(this.world.getTenantId())).setApplicationSessionId(this.world.getApplicationSessionId()), inputStream, Contexts.HOLDING_SCHEME.name(), ProcessAction.RESUME.name());
            String operationId = response.getHeaderString("X-Request-Id");
            this.world.setOperationId(operationId);
            VitamPoolingClient vitamPoolingClient = new VitamPoolingClient((OperationStatusClient)this.world.getAdminClient());
            boolean process_timeout = vitamPoolingClient.wait(this.world.getTenantId(), operationId, ProcessState.COMPLETED, 100, 1000L, TimeUnit.MILLISECONDS);
            if (!process_timeout) {
                Assertions.fail((String)("Sip processing not finished : operation (" + operationId + "). Timeout exceeded."));
            }
            ((AbstractStringAssert)Assertions.assertThat((String)operationId).as(String.format("%s not found for request", "X-Request-Id"), new Object[0])).isNotNull();
        }
        if (attachMode) {
            deleteSip = true;
        }
    }

    @When(value="je construit le sip de rattachement avec le template")
    public void build_the_attachenment_by_systemid() throws IOException {
        this.world.setSipFile(SipTool.copyAndModifyManifestInZip(this.world.getSipFile(), "_REPLACE_ME_", this.world.getUnitId(), null, null));
        attachMode = true;
    }

    @When(value="j'utilise le template et construit un sip de rattachement avec comme nom et valeur de m\u00e9tadonn\u00e9e (.*) et (.*)$")
    public void build_the_attachenment_by_key_value(String metadataName, String metadataValue) throws IOException {
        if (_ID.equals(metadataName) && ID.equals(metadataValue)) {
            metadataValue = this.world.getUnitId();
        }
        this.world.setSipFile(SipTool.copyAndModifyManifestInZip(this.world.getSipFile(), "_REPLACE_ME_NAME_", metadataName, "_REPLACE_ME_VALUE_", metadataValue));
        attachMode = true;
    }

    @When(value="je construit le SIP de rattachement au groupe d'objet existant avec le template")
    public void build_the_attachenment_to_existing_object_group() throws IOException {
        this.world.setSipFile(SipTool.copyAndModifyManifestInZip(this.world.getSipFile(), "_REPLACE_ME_", this.world.getObjectGroupId(), null, null));
        attachMode = true;
    }

    @Given(value="^les donn\u00e9es du jeu de test du SIP nomm\u00e9 (.*)")
    public void use_test_set_from_sip(String fileName) {
        this.a_sip_named(fileName);
        if (!StringUtils.isNotBlank((CharSequence)World.getOperationId(fileName))) {
            try {
                this.upload_this_sip();
                LogbookEventOperation lastEvent = this.world.getLogbookService().checkFinalStatusLogbook(this.world.getAccessClient(), this.world.getTenantId(), this.world.getContractId(), this.world.getApplicationSessionId(), this.world.getOperationId(), "OK");
                this.world.setLogbookEvent((LogbookEvent)lastEvent);
                World.setOperationId(fileName, this.world.getOperationId());
            }
            catch (VitamException | IOException e) {
                Assertions.fail((String)("Could not load test set : operation (" + this.world.getOperationId() + ") : ingest failure."), (Throwable)e);
            }
            return;
        }
        this.world.setOperationId(World.getOperationId(fileName));
    }

    @After
    public void afterScenario() throws IOException {
        if (this.world.getSipFile() != null && deleteSip) {
            try {
                GUIDReader.getGUID((String)this.world.getSipFile().getFileName().toString());
                Files.delete(this.world.getSipFile());
            }
            catch (InvalidGuidOperationException e) {
                LOGGER.info("This is not a guid, no need to delete ", (Throwable)e);
            }
            deleteSip = false;
            attachMode = false;
        }
    }
}

