/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.step;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientServerException;
import fr.gouv.vitam.common.FileUtil;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.ContextModel;
import fr.gouv.vitam.functionaltest.cucumber.step.CommonStep;
import fr.gouv.vitam.functionaltest.cucumber.step.World;
import io.cucumber.datatable.DataTable;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;

public class ContextStep
extends CommonStep {
    private String fileName;
    private String query;
    private static final String OPERATION_ID = "Operation-Id";
    private String contextIdentifier;
    private String contextName;
    private JsonNode model;

    public ContextStep(World world) {
        super(world);
    }

    @Given(value="^un fichier contexte nomm\u00e9 (.*)$")
    public void a_context_file_named(String fileName) {
        this.fileName = fileName;
    }

    @Given(value="^un contexte nomm\u00e9 (.*)$")
    public void a_context_named(String contextName) {
        this.contextName = contextName;
    }

    @Given(value="^un fichier requete nomm\u00e9 (.*)$")
    public void a_file_query_named(String queryContextfileName) {
        this.fileName = queryContextfileName;
    }

    @Then(value="^j'importe ce contexte en succ\u00e8s")
    public void success_upload_context() throws IOException, AccessExternalClientServerException, InvalidParseOperationException {
        Path context = Paths.get(this.world.getBaseDirectory(), this.fileName);
        VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId()));
        vitamContext.setApplicationSessionId(this.world.getApplicationSessionId());
        RequestResponse response = this.world.getAdminClient().createContexts(vitamContext, Files.newInputStream(context, StandardOpenOption.READ));
        String operationId = response.getHeaderString("X-Request-Id");
        this.world.setOperationId(operationId);
        Assertions.assertThat((boolean)response.isOk()).isTrue();
    }

    @Then(value="^j'importe ce contexte en \u00e9chec")
    public void fail_upload_context() throws AccessExternalClientServerException, InvalidParseOperationException, IOException {
        Path context = Paths.get(this.world.getBaseDirectory(), this.fileName);
        RequestResponse response = this.world.getAdminClient().createContexts(new VitamContext(Integer.valueOf(this.world.getTenantId())).setApplicationSessionId(this.world.getApplicationSessionId()), Files.newInputStream(context, StandardOpenOption.READ));
        String operationId = response.getHeaderString("X-Request-Id");
        this.world.setOperationId(operationId);
        Assertions.assertThat((Response.Status.BAD_REQUEST.getStatusCode() == response.getStatus() ? 1 : 0) != 0);
    }

    @When(value="^je modifie le contexte nomm\u00e9 (.*) le statut de la requ\u00eate est (.*)$")
    public void update_context_by_name_query(String name, Integer status) throws InvalidParseOperationException, VitamClientException, IOException, AccessExternalClientException, InvalidCreateOperationException {
        this.contextName = name;
        Path queryFile = Paths.get(this.world.getBaseDirectory(), this.fileName);
        this.query = FileUtil.readFile((File)queryFile.toFile());
        if (this.world.getOperationId() != null) {
            this.query = this.query.replace(OPERATION_ID, this.world.getOperationId());
        }
        JsonNode queryDsl = JsonHandler.getFromString((String)this.query);
        this.find_a_context_id(this.contextName);
        VitamContext context = new VitamContext(Integer.valueOf(this.world.getTenantId()));
        context.setApplicationSessionId(this.world.getApplicationSessionId());
        RequestResponse requestResponse = this.world.getAdminClient().updateContext(context, this.contextIdentifier, queryDsl);
        Assertions.assertThat((int)requestResponse.getHttpCode()).isEqualTo((Object)status);
        String operationId = requestResponse.getHeaderString("X-Request-Id");
        this.world.setOperationId(operationId);
    }

    @When(value="^je modifie le contexte dont l'identifiant est (.*) le statut de la requ\u00eate est (.*)$")
    public void update_context_by_identifier_query(String contextIdentifier, Integer status) throws InvalidParseOperationException, IOException, AccessExternalClientException {
        Path queryFile = Paths.get(this.world.getBaseDirectory(), this.fileName);
        this.query = FileUtil.readFile((File)queryFile.toFile());
        if (this.world.getOperationId() != null) {
            this.query = this.query.replace(OPERATION_ID, this.world.getOperationId());
        }
        JsonNode queryDsl = JsonHandler.getFromString((String)this.query);
        VitamContext context = new VitamContext(Integer.valueOf(this.world.getTenantId()));
        context.setApplicationSessionId(this.world.getApplicationSessionId());
        RequestResponse requestResponse = this.world.getAdminClient().updateContext(context, contextIdentifier, queryDsl);
        Assertions.assertThat((int)requestResponse.getHttpCode()).isEqualTo((Object)status);
        String operationId = requestResponse.getHeaderString("X-Request-Id");
        this.world.setOperationId(operationId);
    }

    @When(value="^je recherche un contexte nomm\u00e9 (.*)$")
    public void find_a_context_id(String name) throws VitamClientException, InvalidCreateOperationException, InvalidParseOperationException {
        Select select = new Select();
        select.setQuery((Query)QueryHelper.eq((String)"Name", (String)name));
        ObjectNode queryDsl = select.getFinalSelect();
        RequestResponse requestResponse = this.world.getAdminClient().findContexts(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(null).setApplicationSessionId(this.world.getApplicationSessionId()), (JsonNode)queryDsl);
        if (requestResponse.isOk()) {
            ContextModel model = (ContextModel)((RequestResponseOK)requestResponse).getFirstResult();
            this.model = JsonHandler.toJsonNode((Object)model);
            this.contextIdentifier = ((ContextModel)((RequestResponseOK)requestResponse).getFirstResult()).getIdentifier();
            return;
        }
        throw new VitamClientException("No context was found");
    }

    @Then(value="^les m\u00e9tadonn\u00e9es du context sont$")
    public void metadata_are(DataTable dataTable) {
        List raws = dataTable.cells();
        for (List raw : raws) {
            String index = (String)raw.get(0);
            String value = (String)raw.get(1);
            if (this.model.get(index).isArray()) {
                Assertions.assertThat((String)value).isEqualTo(this.model.get(index).toString());
                continue;
            }
            Assertions.assertThat((String)value).contains(new CharSequence[]{this.model.get(index).asText()});
        }
    }
}

