/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.step;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.collect.common.dto.ProjectDto;
import fr.gouv.vitam.collect.common.dto.TransactionDto;
import fr.gouv.vitam.common.FileUtil;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.SysErrLogger;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.functionaltest.cucumber.step.CommonStep;
import fr.gouv.vitam.functionaltest.cucumber.step.World;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import net.javacrumbs.jsonunit.JsonAssert;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.Option;
import org.apache.commons.lang3.time.StopWatch;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.junit.Assume;

public class CollectStep
extends CommonStep {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CollectStep.class);
    public static final String TRANSACTION_RETURN_AN_ERROR = "request find_transaction return an error: ";
    private static final String CREATED = "cr\u00e9\u00e9";
    private static final String DELETED = "supprim\u00e9";

    public CollectStep(World world) {
        super(world);
    }

    @Given(value="^Le module de collect est deploy\u00e9")
    public void checkSkippableScenario() {
        try {
            this.world.getCollectExternalClient().checkStatus();
        }
        catch (Exception e) {
            LOGGER.warn("Collect service is not deployed or not up!");
            Assume.assumeTrue((boolean)false);
        }
    }

    @When(value="^j'initialise le project")
    public void init_project() throws Throwable {
        ProjectDto queryJSON = (ProjectDto)JsonHandler.getFromString((String)this.world.getQuery(), ProjectDto.class);
        RequestResponse resultedRequestResponse = this.world.getCollectExternalClient().initProject(new VitamContext(Integer.valueOf(this.world.getTenantId())), queryJSON);
        if (resultedRequestResponse.isOk()) {
            RequestResponseOK requestResponseOK = (RequestResponseOK)resultedRequestResponse;
            Assertions.assertThat((List)requestResponseOK.getResults()).isNotEmpty();
            this.world.setResults(requestResponseOK.getResults());
            ProjectDto projectDto = (ProjectDto)JsonHandler.getFromString((String)this.world.getResults().get(0).toString(), ProjectDto.class);
            this.world.setProjectId(projectDto.getId());
        } else {
            VitamError vitamError = (VitamError)resultedRequestResponse;
            Fail.fail((String)("request initProject return an error: " + vitamError.getCode()));
        }
    }

    @When(value="^j'utilise le fichier json suivant (.*)$")
    public void i_use_the_following_file_query(String jsonFilename) throws Throwable {
        Path jsonFile = Paths.get(this.world.getBaseDirectory(), jsonFilename);
        String json = FileUtil.readFile((File)jsonFile.toFile());
        this.world.setQuery(json);
    }

    @When(value="^je recherche le projet")
    public void find_project() throws Throwable {
        ProjectDto projectDto = (ProjectDto)JsonHandler.getFromString((String)this.world.getResults().get(0).toString(), ProjectDto.class);
        RequestResponse requestResponse = this.world.getCollectExternalClient().getProjectById(new VitamContext(Integer.valueOf(this.world.getTenantId())), projectDto.getId());
        if (requestResponse.isOk()) {
            RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
            Assertions.assertThat((List)requestResponseOK.getResults()).isNotEmpty();
            this.world.setResults(requestResponseOK.getResults());
        } else {
            VitamError vitamError = (VitamError)requestResponse;
            Fail.fail((String)("request initProject return an error: " + vitamError.getCode()));
        }
    }

    @When(value="^je met a jour le projet avec le nom (.*)$")
    public void update_project(String name) throws Throwable {
        ProjectDto projectDto = (ProjectDto)JsonHandler.getFromString((String)this.world.getResults().get(0).toString(), ProjectDto.class);
        projectDto.setName(name);
        RequestResponse requestResponse = this.world.getCollectExternalClient().updateProject(new VitamContext(Integer.valueOf(this.world.getTenantId())), projectDto);
        if (requestResponse.isOk()) {
            RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
            Assertions.assertThat((List)requestResponseOK.getResults()).isNotEmpty();
            this.world.setResults(requestResponseOK.getResults());
            ProjectDto updatedProjectDto = (ProjectDto)JsonHandler.getFromString((String)this.world.getResults().get(0).toString(), ProjectDto.class);
            Assertions.assertThat((String)updatedProjectDto.getName()).isEqualTo(projectDto.getName());
            Assertions.assertThat((String)updatedProjectDto.getId()).isEqualTo(projectDto.getId());
        } else {
            VitamError vitamError = (VitamError)requestResponse;
            Fail.fail((String)("request update project return an error: " + vitamError.getCode()));
        }
    }

    @When(value="^je met a jour la transaction avec le nom (.*)$")
    public void update_transaction(String name) throws Exception {
        TransactionDto transactionDto = (TransactionDto)JsonHandler.getFromString((String)this.world.getResults().get(0).toString(), TransactionDto.class);
        transactionDto.setName(name);
        RequestResponse requestResponse = this.world.getCollectExternalClient().updateTransaction(new VitamContext(Integer.valueOf(this.world.getTenantId())), transactionDto);
        if (requestResponse.isOk()) {
            RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
            Assertions.assertThat((List)requestResponseOK.getResults()).isNotEmpty();
            this.world.setResults(requestResponseOK.getResults());
            TransactionDto updatedTransactionDto = (TransactionDto)JsonHandler.getFromString((String)this.world.getResults().get(0).toString(), TransactionDto.class);
            Assertions.assertThat((String)updatedTransactionDto.getName()).isEqualTo(transactionDto.getName());
            Assertions.assertThat((String)updatedTransactionDto.getId()).isEqualTo(transactionDto.getId());
        } else {
            VitamError vitamError = (VitamError)requestResponse;
            Fail.fail((String)("request update project return an error: " + vitamError.getCode()));
        }
    }

    @When(value="^je supprime le projet")
    public void purge_project() throws Throwable {
        ProjectDto projectDto = (ProjectDto)JsonHandler.getFromString((String)this.world.getResults().get(0).toString(), ProjectDto.class);
        RequestResponse requestResponse = this.world.getCollectExternalClient().deleteProjectById(new VitamContext(Integer.valueOf(this.world.getTenantId())), projectDto.getId());
        if (requestResponse.getHttpCode() != 200) {
            VitamError vitamError = (VitamError)requestResponse;
            Fail.fail((String)("request purge project return an error: " + vitamError.getCode()));
        }
    }

    @Then(value="^le projet est (.*) en succ\u00e8s$")
    public void checkOperationProject(String action) throws InvalidParseOperationException {
        ProjectDto projectDto = (ProjectDto)JsonHandler.getFromString((String)this.world.getResults().get(0).toString(), ProjectDto.class);
        switch (action) {
            case "cr\u00e9\u00e9": {
                this.checkCreatedProject(projectDto);
                break;
            }
            case "supprim\u00e9": {
                this.checkDeletedProject(projectDto);
                break;
            }
            default: {
                Fail.fail((String)"Not recognized action !");
            }
        }
    }

    private void checkDeletedProject(ProjectDto projectDto) {
        Assertions.assertThatThrownBy(() -> this.world.getCollectExternalClient().getProjectById(new VitamContext(Integer.valueOf(this.world.getTenantId())), projectDto.getId())).isInstanceOf(VitamClientException.class);
    }

    private void checkCreatedProject(ProjectDto projectDto) throws InvalidParseOperationException {
        try {
            RequestResponse requestResponse = this.world.getCollectExternalClient().getProjectById(new VitamContext(Integer.valueOf(this.world.getTenantId())), projectDto.getId());
            RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
            Assertions.assertThat((List)requestResponseOK.getResults()).isNotEmpty();
            this.world.setResults(requestResponseOK.getResults());
            ProjectDto createdProject = (ProjectDto)JsonHandler.getFromString((String)this.world.getResults().get(0).toString(), ProjectDto.class);
            Assertions.assertThat((String)createdProject.getId()).isEqualTo(projectDto.getId());
            Assertions.assertThat((String)createdProject.getName()).isEqualTo(projectDto.getName());
        }
        catch (VitamClientException e) {
            Fail.fail((String)e.getMessage());
        }
    }

    @When(value="^j'initialise une transaction")
    public void init_transaction() throws Throwable {
        TransactionDto queryJSON = (TransactionDto)JsonHandler.getFromString((String)this.world.getQuery(), TransactionDto.class);
        RequestResponse requestResponse = this.world.getCollectExternalClient().initTransaction(new VitamContext(Integer.valueOf(this.world.getTenantId())), queryJSON, this.world.getProjectId());
        if (requestResponse.isOk()) {
            RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
            Assertions.assertThat((List)requestResponseOK.getResults()).isNotEmpty();
            this.world.setResults(requestResponseOK.getResults());
        } else {
            VitamError vitamError = (VitamError)requestResponse;
            Fail.fail((String)("request initTransaction return an error: " + vitamError.getCode()));
        }
    }

    @When(value="^je recherche la transaction")
    public void find_transaction() throws Throwable {
        TransactionDto transactionDto = (TransactionDto)JsonHandler.getFromString((String)this.world.getResults().get(0).toString(), TransactionDto.class);
        RequestResponse requestResponse = this.world.getCollectExternalClient().getTransactionById(new VitamContext(Integer.valueOf(this.world.getTenantId())), transactionDto.getId());
        if (requestResponse.isOk()) {
            RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
            Assertions.assertThat((List)requestResponseOK.getResults()).isNotEmpty();
            this.world.setResults(requestResponseOK.getResults());
            TransactionDto myTransactionDto = (TransactionDto)JsonHandler.getFromString((String)this.world.getResults().get(0).toString(), TransactionDto.class);
            this.world.setTransactionId(myTransactionDto.getId());
            Assertions.assertThat((String)myTransactionDto.getStatus()).isEqualTo("OPEN");
        } else {
            VitamError vitamError = (VitamError)requestResponse;
            Fail.fail((String)(TRANSACTION_RETURN_AN_ERROR + vitamError.getCode()));
        }
    }

    @When(value="^je cr\u00e9e une au")
    public void uploadUnit() throws Exception {
        String transactionId = this.world.getTransactionId();
        JsonNode archiveUnitJson = JsonHandler.getFromString((String)this.world.getQuery());
        RequestResponse response = this.world.getCollectExternalClient().uploadArchiveUnit(new VitamContext(Integer.valueOf(this.world.getTenantId())), archiveUnitJson, transactionId);
        Assertions.assertThat((boolean)response.isOk()).isTrue();
        Assertions.assertThat((Object)((RequestResponseOK)response).getFirstResult()).isNotNull();
        Assertions.assertThat((Iterable)((JsonNode)((RequestResponseOK)response).getFirstResult()).get("#id")).isNotNull();
        this.world.setUnitId(((JsonNode)((RequestResponseOK)response).getFirstResult()).get("#id").asText());
    }

    @When(value="^je recherche l'au par rapport \u00e0 son titre")
    public void getUnitByDslQuery() throws Exception {
        String transactionId = this.world.getTransactionId();
        String unitDsl = "{\"$roots\": [],\"$query\": [{\"$eq\" : {\"Title\":\"My title3\"}}],\"$filter\": {\"$offset\": 0,\"$limit\": 100},\"$projection\": {}}";
        RequestResponse response = this.world.getCollectExternalClient().getUnitsByTransaction(new VitamContext(Integer.valueOf(this.world.getTenantId())), transactionId, JsonHandler.getFromString((String)unitDsl));
        Assertions.assertThat((int)response.getStatus()).isEqualTo(200);
        Assertions.assertThat((Object)((RequestResponseOK)response).getFirstResult()).isNotNull();
        Assertions.assertThat((long)((RequestResponseOK)response).getHits().getTotal()).isEqualTo(1L);
    }

    @When(value="^je cr\u00e9e un GOT")
    public void uploadGot() throws Exception {
        String unitId = this.world.getUnitId();
        Integer version = 1;
        String usage = "TextContent";
        JsonNode gotJson = JsonHandler.getFromString((String)this.world.getQuery());
        RequestResponse response = this.world.getCollectExternalClient().addObjectGroup(new VitamContext(Integer.valueOf(this.world.getTenantId())), unitId, version, gotJson, usage);
        Assertions.assertThat((boolean)response.isOk()).isTrue();
        Assertions.assertThat((Object)((RequestResponseOK)response).getFirstResult()).isNotNull();
        Assertions.assertThat((Iterable)((JsonNode)((RequestResponseOK)response).getFirstResult()).get("_id")).isNotNull();
        ((JsonNode)((RequestResponseOK)response).getFirstResult()).get("_id").textValue();
    }

    @When(value="^j'upload le fichier suivant (.*)$")
    public void uploadBinary(String binaryFilename) throws Exception {
        String unitId = this.world.getUnitId();
        Integer version = 1;
        String usage = "TextContent";
        try (InputStream inputStream = Files.newInputStream(Paths.get(this.world.getBaseDirectory(), binaryFilename), new OpenOption[0]);){
            Response response = this.world.getCollectExternalClient().addBinary(new VitamContext(Integer.valueOf(this.world.getTenantId())), unitId, version, inputStream, usage);
            Assertions.assertThat((int)response.getStatus()).isEqualTo(200);
        }
    }

    @When(value="^je cl\u00f4ture et je constate son statut (.*)$")
    public void closeTransaction(String status) throws Exception {
        String transactionId = this.world.getTransactionId();
        RequestResponse response = this.world.getCollectExternalClient().closeTransaction(new VitamContext(Integer.valueOf(this.world.getTenantId())), transactionId);
        Assertions.assertThat((int)response.getStatus()).isEqualTo(200);
        RequestResponse requestResponse = this.world.getCollectExternalClient().getTransactionById(new VitamContext(Integer.valueOf(this.world.getTenantId())), this.world.getTransactionId());
        if (requestResponse.isOk()) {
            RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
            Assertions.assertThat((List)requestResponseOK.getResults()).isNotEmpty();
            TransactionDto myTransactionDto = (TransactionDto)JsonHandler.getFromString((String)((JsonNode)requestResponseOK.getResults().get(0)).toString(), TransactionDto.class);
            Assertions.assertThat((String)myTransactionDto.getStatus()).isEqualTo(status);
        } else {
            VitamError vitamError = (VitamError)requestResponse;
            Fail.fail((String)(TRANSACTION_RETURN_AN_ERROR + vitamError.getCode()));
        }
    }

    @When(value="^j'envoie le SIP et je constate son statut (.*)$")
    public void sentSip(String status) throws Exception {
        RequestResponse requestResponse;
        RequestResponse response = this.world.getCollectExternalClient().ingest(new VitamContext(Integer.valueOf(this.world.getTenantId())), this.world.getTransactionId());
        if (Response.Status.Family.SUCCESSFUL.equals((Object)response.getStatus())) {
            Assertions.assertThat((int)response.getStatus()).isEqualTo(200);
        }
        if ((requestResponse = this.world.getCollectExternalClient().getTransactionById(new VitamContext(Integer.valueOf(this.world.getTenantId())), this.world.getTransactionId())).isOk()) {
            RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
            Assertions.assertThat((List)requestResponseOK.getResults()).isNotEmpty();
            TransactionDto myTransactionDto = (TransactionDto)JsonHandler.getFromString((String)((JsonNode)requestResponseOK.getResults().get(0)).toString(), TransactionDto.class);
            Assertions.assertThat((String)myTransactionDto.getStatus()).isEqualTo(status);
            Assertions.assertThat((String)myTransactionDto.getVitamOperationId()).isNotNull();
            Assertions.assertThat((String)myTransactionDto.getVitamOperationId()).isNotEmpty();
        } else {
            VitamError vitamError = (VitamError)requestResponse;
            Fail.fail((String)(TRANSACTION_RETURN_AN_ERROR + vitamError.getCode()));
        }
    }

    public boolean waitTransaction(String status, int nbTry, long timeWait, TimeUnit timeUnit) throws VitamException {
        StopWatch stopWatch = StopWatch.createStarted();
        do {
            RequestResponse requestResponse;
            if ((requestResponse = this.world.getCollectExternalClient().getTransactionById(new VitamContext(Integer.valueOf(this.world.getTenantId())), this.world.getTransactionId())).isOk()) {
                RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
                TransactionDto myTransactionDto = (TransactionDto)JsonHandler.getFromString((String)((JsonNode)requestResponseOK.getResults().get(0)).toString(), TransactionDto.class);
                if (status.equals(myTransactionDto.getStatus())) {
                    return true;
                }
                if (stopWatch.getTime(TimeUnit.MINUTES) > 15L) {
                    return false;
                }
                if (null != timeUnit) {
                    timeWait = timeUnit.toMillis(timeWait);
                }
                if (--nbTry <= 0) continue;
                try {
                    Thread.sleep(timeWait);
                }
                catch (InterruptedException e) {
                    SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e);
                }
                continue;
            }
            throw new VitamException((VitamError)requestResponse);
        } while (nbTry > 0);
        return false;
    }

    @Given(value="^je re\u00e7ois un statut OK depuis l'ingest et je constate son statut (.*)$")
    public void verifyOkStatus(String status) throws Exception {
        this.verifyStatus(status);
    }

    @Given(value="^je re\u00e7ois un statut KO depuis l'ingest et je constate son statut (.*)$")
    public void verifyKOStatus(String status) throws Exception {
        this.verifyStatus(status);
    }

    public void verifyStatus(String status) throws Exception {
        RequestResponse requestResponse;
        boolean processTimeout = this.waitTransaction(status, 100, 5000L, TimeUnit.MILLISECONDS);
        if (!processTimeout) {
            Assertions.fail((String)("Sip processing not finished : operation (" + this.world.getOperationId() + "). Timeout exceeded."));
        }
        if ((requestResponse = this.world.getCollectExternalClient().getTransactionById(new VitamContext(Integer.valueOf(this.world.getTenantId())), this.world.getTransactionId())).isOk()) {
            RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
            Assertions.assertThat((List)requestResponseOK.getResults()).isNotEmpty();
            TransactionDto myTransactionDto = (TransactionDto)JsonHandler.getFromString((String)((JsonNode)requestResponseOK.getResults().get(0)).toString(), TransactionDto.class);
            Assertions.assertThat((String)myTransactionDto.getStatus()).isEqualTo(status);
        } else {
            VitamError vitamError = (VitamError)requestResponse;
            Fail.fail((String)(TRANSACTION_RETURN_AN_ERROR + vitamError.getCode()));
        }
    }

    @When(value="^j'envoie l'arborescence bureautique suivante (.*)$")
    public void should_upload_project_zip(String arboFileName) throws Exception {
        try (InputStream inputStream = Files.newInputStream(Paths.get(this.world.getBaseDirectory(), arboFileName), new OpenOption[0]);){
            RequestResponse response = this.world.getCollectExternalClient().uploadZipToTransaction(new VitamContext(Integer.valueOf(this.world.getTenantId())), this.world.getTransactionId(), inputStream);
            Assertions.assertThat((int)response.getStatus()).isEqualTo(200);
        }
    }

    @When(value="^j'envoie un fichier de mise \u00e0 jour CSV (.*)$")
    public void should_upload_metadata_csv(String arboFileName) throws Exception {
        try (InputStream inputStream = Files.newInputStream(Paths.get(this.world.getBaseDirectory(), arboFileName), new OpenOption[0]);){
            RequestResponse response = this.world.getCollectExternalClient().updateUnitsWithCsvMetadata(new VitamContext(Integer.valueOf(this.world.getTenantId())), this.world.getTransactionId(), inputStream);
            Assertions.assertThat((int)response.getStatus()).isEqualTo(200);
        }
    }

    @When(value="^j'envoie un fichier de mise \u00e0 jour JSONL (.*)$")
    public void should_upload_metadata_jsonl(String arboFileName) throws Exception {
        try (InputStream inputStream = Files.newInputStream(Paths.get(this.world.getBaseDirectory(), arboFileName), new OpenOption[0]);){
            RequestResponse response = this.world.getCollectExternalClient().updateUnitsWithJsonlMetadata(new VitamContext(Integer.valueOf(this.world.getTenantId())), this.world.getTransactionId(), inputStream);
            Assertions.assertThat((int)response.getStatus()).isEqualTo(200);
        }
    }

    @When(value="^je constate que des m\u00e9tadonn\u00e9es correspondent au fichier json (.+)$")
    public void json_metadata_are_for_particular_result(String filename) throws Throwable {
        JsonNode expectedJson;
        RequestResponse requestResponse = this.world.getCollectExternalClient().getUnitsByTransaction(new VitamContext(Integer.valueOf(this.world.getTenantId())), this.world.getTransactionId(), (JsonNode)new SelectMultiQuery().getFinalSelect());
        Path file = Paths.get(this.world.getBaseDirectory(), filename);
        try (InputStream inputStream = Files.newInputStream(file, StandardOpenOption.READ);){
            expectedJson = JsonHandler.getFromInputStream((InputStream)inputStream);
        }
        RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
        Assertions.assertThat((List)requestResponseOK.getResults()).isNotEmpty();
        JsonAssert.assertJsonEquals((Object)JsonHandler.toJsonNode((Object)requestResponseOK.getResults()), (Object)expectedJson, (Configuration)JsonAssert.when((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0]).whenIgnoringPaths(List.of("[*]." + VitamFieldsHelper.initialOperation(), "[*]." + VitamFieldsHelper.id(), "[*]." + VitamFieldsHelper.batchId(), "[*]." + VitamFieldsHelper.unitups(), "[*]." + VitamFieldsHelper.object(), "[*]." + VitamFieldsHelper.allunitups(), "[*]." + VitamFieldsHelper.initialOperation(), "[*]." + VitamFieldsHelper.approximateCreationDate(), "[*]." + VitamFieldsHelper.version(), "[*]." + VitamFieldsHelper.unitType(), "[*]." + VitamFieldsHelper.min(), "[*]." + VitamFieldsHelper.max(), "[*]." + VitamFieldsHelper.tenant(), "[*]." + VitamFieldsHelper.originatingAgencies(), "[*]." + VitamFieldsHelper.approximateUpdateDate())));
    }

    @When(value="^je constate qu'une AU ainsi qu'un GOT sont cr\u00e9\u00e9s")
    public void should_find_au() throws Exception {
        RequestResponse requestResponse = this.world.getCollectExternalClient().getUnitsByTransaction(new VitamContext(Integer.valueOf(this.world.getTenantId())), this.world.getTransactionId(), (JsonNode)new SelectMultiQuery().getFinalSelect());
        if (requestResponse.isOk()) {
            RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
            Assertions.assertThat((List)requestResponseOK.getResults()).isNotEmpty();
            Assertions.assertThat((Iterable)((JsonNode)requestResponseOK.getFirstResult()).get("#id")).isNotNull();
            Optional<JsonNode> got = requestResponseOK.getResults().stream().filter(jsonNode -> "Item".equals(jsonNode.get("DescriptionLevel").asText())).findFirst();
            Assertions.assertThat(got).isNotNull();
        } else {
            VitamError vitamError = (VitamError)requestResponse;
            Fail.fail((String)(TRANSACTION_RETURN_AN_ERROR + vitamError.getCode()));
        }
    }
}

