/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.step;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.functionaltest.cucumber.step.CommonStep;
import fr.gouv.vitam.functionaltest.cucumber.step.World;
import io.cucumber.datatable.DataTable;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;

public class AccessionRegisterStep
extends CommonStep {
    private static final String ACCESSION_REGISTER_SUMMARY_ERROR_MESSAGE = "no accession register summary in result since an error occured: ";
    private static final String ACCESSION_REGISTER_DETAIL_ERROR_MESSAGE = "no accession register detail in result since an error occured: ";
    private RequestResponse requestResponse;

    public AccessionRegisterStep(World world) {
        super(world);
    }

    @When(value="^je recherche les registres de fond$")
    public void search_accession_register() throws Throwable {
        RequestResponse requestResponse;
        JsonNode queryJSON = JsonHandler.getFromString((String)this.world.getQuery());
        this.requestResponse = requestResponse = this.world.getAdminClient().findAccessionRegister(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId()), queryJSON);
    }

    @When(value="^je recherche les d\u00e9tails des registres de fonds$")
    public void search_accession_register_details() throws Throwable {
        RequestResponse requestResponse;
        JsonNode queryJSON = JsonHandler.getFromString((String)this.world.getQuery());
        this.requestResponse = requestResponse = this.world.getAdminClient().findAccessionRegisterDetails(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId()), queryJSON);
    }

    @When(value="^je recherche les d\u00e9tails des registres de fond pour le service producteur (.*)$")
    public void search_accession_regiter_detail(String originatingAgency) throws Throwable {
        RequestResponse requestResponse;
        JsonNode queryJSON = JsonHandler.getFromString((String)this.world.getQuery());
        this.requestResponse = requestResponse = this.world.getAdminClient().getAccessionRegisterDetail(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId()), originatingAgency, queryJSON);
    }

    @Then(value="^le nombre de registres de fond est (\\d+)$")
    public void number_of_accession_register_summary_result_are(int numberOfResults) throws Throwable {
        if (this.requestResponse.isOk()) {
            Assertions.assertThat((List)((RequestResponseOK)this.requestResponse).getResults()).hasSize(numberOfResults);
        } else {
            VitamError vitamError = (VitamError)this.requestResponse;
            Fail.fail((String)(ACCESSION_REGISTER_SUMMARY_ERROR_MESSAGE + JsonHandler.prettyPrint((Object)vitamError)));
        }
    }

    @Then(value="^le nombre de d\u00e9tails du registre de fond est (\\d+)$")
    public void number_of_accession_register_detail_result_are(int numberOfResults) throws Throwable {
        if (this.requestResponse.isOk()) {
            Assertions.assertThat((List)((RequestResponseOK)this.requestResponse).getResults()).hasSize(numberOfResults);
        } else {
            VitamError vitamError = (VitamError)this.requestResponse;
            Fail.fail((String)(ACCESSION_REGISTER_DETAIL_ERROR_MESSAGE + JsonHandler.prettyPrint((Object)vitamError)));
        }
    }

    @Then(value="^les metadonn\u00e9es pour le registre de fond sont$")
    public void metadata_accession_register_summary_are(DataTable dataTable) throws Throwable {
        this.metadata_accession_register_summary_are_for_particular_result(0, dataTable);
    }

    @Then(value="^les metadonn\u00e9es pour le d\u00e9tail du registre de fond sont$")
    public void metadata_accession_register_detail_are(DataTable dataTable) throws Throwable {
        this.metadata_accession_register_detail_are_for_particular_result(0, dataTable);
    }

    @Then(value="^les metadonn\u00e9es pour le registre de fond num\u00e9ro (\\d+) sont$")
    public void metadata_accession_register_summary_are_for_particular_result(int resultNumber, DataTable dataTable) throws Throwable {
        if (this.requestResponse.isOk()) {
            this.world.getAccessService().checkResultsForParticularData(((RequestResponseOK)this.requestResponse).getResultsAsJsonNodes(), resultNumber, dataTable);
        } else {
            VitamError vitamError = (VitamError)this.requestResponse;
            Fail.fail((String)(ACCESSION_REGISTER_SUMMARY_ERROR_MESSAGE + JsonHandler.prettyPrint((Object)vitamError)));
        }
    }

    @Then(value="^les metadonn\u00e9es pour le d\u00e9tail du registre de fond num\u00e9ro (\\d+) sont$")
    public void metadata_accession_register_detail_are_for_particular_result(int resultNumber, DataTable dataTable) throws Throwable {
        if (this.requestResponse.isOk()) {
            this.world.getAccessService().checkResultsForParticularData(((RequestResponseOK)this.requestResponse).getResultsAsJsonNodes(), resultNumber, dataTable);
        } else {
            VitamError vitamError = (VitamError)this.requestResponse;
            Fail.fail((String)(ACCESSION_REGISTER_DETAIL_ERROR_MESSAGE + JsonHandler.prettyPrint((Object)vitamError)));
        }
    }
}

