/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.client;

import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.client.VitamClientFactory;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.client.configuration.ClientConfigurationImpl;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientMock;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientRest;
import java.io.File;
import java.io.IOException;

public class AdminManagementClientFactory
extends VitamClientFactory<AdminManagementClient> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AdminManagementClientFactory.class);
    private static final AdminManagementClientFactory ADMIN_MANAGEMENT_CLIENT_FACTORY = new AdminManagementClientFactory();
    private static final String CONFIGURATION_FILENAME = "functional-administration-client.conf";
    private static final String RESOURCE_PATH = "/adminmanagement/v1";

    private AdminManagementClientFactory() {
        super(AdminManagementClientFactory.changeConfigurationFile(CONFIGURATION_FILENAME), RESOURCE_PATH, true);
    }

    public static final AdminManagementClientFactory getInstance() {
        return ADMIN_MANAGEMENT_CLIENT_FACTORY;
    }

    public AdminManagementClient getClient() {
        AdminManagementClient client;
        switch (this.getVitamClientType()) {
            case MOCK: {
                client = new AdminManagementClientMock();
                break;
            }
            case PRODUCTION: {
                client = new AdminManagementClientRest(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Admin management client type unknown");
            }
        }
        return client;
    }

    static final ClientConfiguration changeConfigurationFile(String configurationPath) {
        ClientConfiguration configuration = null;
        try {
            configuration = (ClientConfiguration)PropertiesUtils.readYaml((File)PropertiesUtils.findFile((String)configurationPath), ClientConfigurationImpl.class);
        }
        catch (IOException fnf) {
            LOGGER.debug("Error when retrieving configuration file {}, using mock", (Object)configurationPath, (Object)fnf);
        }
        if (configuration == null) {
            LOGGER.error("Error when retrieving configuration file {}, using mock", (Object)configurationPath);
        }
        return configuration;
    }

    public static final void changeMode(ClientConfiguration configuration) {
        AdminManagementClientFactory.getInstance().initialisation(configuration, AdminManagementClientFactory.getInstance().getResourcePath());
    }
}

