/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.common.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.annotations.VisibleForTesting;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoWriteException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.model.Filters;
import fr.gouv.vitam.common.client.OntologyLoader;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Delete;
import fr.gouv.vitam.common.database.builder.request.single.Insert;
import fr.gouv.vitam.common.database.parser.request.single.DeleteParserSingle;
import fr.gouv.vitam.common.database.parser.request.single.SelectParserSingle;
import fr.gouv.vitam.common.database.parser.request.single.UpdateParserSingle;
import fr.gouv.vitam.common.database.server.DbRequestHelper;
import fr.gouv.vitam.common.database.server.DbRequestResult;
import fr.gouv.vitam.common.database.server.DbRequestSingle;
import fr.gouv.vitam.common.database.server.DocumentValidator;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.DocumentAlreadyExistsException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.SchemaValidationException;
import fr.gouv.vitam.common.exception.VitamDBException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.functional.administration.common.config.ElasticsearchFunctionalAdminIndexManager;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessReferential;
import fr.gouv.vitam.functional.administration.common.server.ReferentialDocumentValidators;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoDbAccessAdminImpl
extends MongoDbAccess
implements MongoDbAccessReferential {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MongoDbAccessAdminImpl.class);
    private final ElasticsearchFunctionalAdminIndexManager indexManager;
    private final OntologyLoader ontologyLoader;

    protected MongoDbAccessAdminImpl(MongoClient mongoClient, String dbname, boolean recreate, ElasticsearchFunctionalAdminIndexManager indexManager, OntologyLoader ontologyLoader) {
        super(mongoClient, dbname);
        this.indexManager = indexManager;
        for (FunctionalAdminCollections collection : FunctionalAdminCollections.values()) {
            collection.initialize(super.getMongoDatabase(), recreate);
        }
        this.ontologyLoader = ontologyLoader;
    }

    @Override
    public DbRequestResult insertDocuments(ArrayNode arrayNode, FunctionalAdminCollections collection) throws ReferentialException, SchemaValidationException, DocumentAlreadyExistsException {
        return this.insertDocuments(arrayNode, collection, 0);
    }

    @Override
    public DbRequestResult insertDocuments(ArrayNode arrayNode, FunctionalAdminCollections collection, Integer version) throws DocumentAlreadyExistsException, ReferentialException, SchemaValidationException {
        try {
            DbRequestSingle dbrequest = new DbRequestSingle(collection.getVitamCollection(), this.ontologyLoader, this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(null));
            Insert insertquery = new Insert();
            insertquery.setData((JsonNode)arrayNode);
            DocumentValidator documentValidator = ReferentialDocumentValidators.getValidator(collection);
            return dbrequest.execute(insertquery, version, documentValidator);
        }
        catch (MongoBulkWriteException | MongoWriteException | InvalidCreateOperationException | BadRequestException | DatabaseException | InvalidParseOperationException | VitamDBException e) {
            if (DbRequestHelper.isDuplicateKeyError((Exception)e)) {
                throw new DocumentAlreadyExistsException("Documents already exists: Duplicate Key", e);
            }
            throw new ReferentialException("Insert Documents Exception", e);
        }
    }

    @Override
    @VisibleForTesting
    public DbRequestResult deleteCollectionForTesting(FunctionalAdminCollections collection, Delete delete) throws DatabaseException {
        long count;
        if (collection.isMultitenant()) {
            Document filter = new Document().append("_tenant", (Object)ParameterHelper.getTenantParameter());
            count = collection.getCollection().countDocuments((Bson)filter);
        } else {
            count = collection.getCollection().countDocuments();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(collection.getName() + " count before: " + count);
        }
        if (count > 0L) {
            DbRequestResult dbRequestResult;
            block13: {
                DbRequestSingle dbrequest = new DbRequestSingle(collection.getVitamCollection(), this.ontologyLoader, this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(null));
                DbRequestResult result = dbrequest.execute(delete);
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(collection.getName() + " result.result.getDeletedCount(): " + result.getCount());
                    }
                    dbRequestResult = result;
                    if (result == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (result != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InvalidCreateOperationException | BadRequestException | InvalidParseOperationException | SchemaValidationException | VitamDBException e) {
                        throw new DatabaseException("Delete document exception", e);
                    }
                }
                result.close();
            }
            return dbRequestResult;
        }
        return new DbRequestResult();
    }

    @Override
    @VisibleForTesting
    public DbRequestResult deleteCollectionForTesting(FunctionalAdminCollections collection) throws DatabaseException, SchemaValidationException {
        long count;
        if (collection.isMultitenant()) {
            Document filter = new Document().append("_tenant", (Object)ParameterHelper.getTenantParameter());
            count = collection.getCollection().countDocuments((Bson)filter);
        } else {
            count = collection.getCollection().countDocuments();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(collection.getName() + " count before: " + count);
        }
        if (count > 0L) {
            DbRequestResult dbRequestResult;
            block14: {
                Delete delete = new Delete();
                DbRequestSingle dbrequest = new DbRequestSingle(collection.getVitamCollection(), this.ontologyLoader, this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(null));
                DbRequestResult result = dbrequest.execute(delete);
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(collection.getName() + " result.result.getDeletedCount(): " + result.getCount());
                    }
                    if (result.getCount() != count) {
                        throw new DatabaseException(String.format("%s: Delete %s from %s elements", collection.getName(), result.getCount(), count));
                    }
                    dbRequestResult = result;
                    if (result == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (result != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InvalidCreateOperationException | BadRequestException | InvalidParseOperationException | VitamDBException e) {
                        throw new DatabaseException("Delete document exception", e);
                    }
                }
                result.close();
            }
            return dbRequestResult;
        }
        return new DbRequestResult();
    }

    @Override
    @VisibleForTesting
    public VitamDocument<?> getDocumentById(String id, FunctionalAdminCollections collection) {
        return (VitamDocument)collection.getCollection().find(Filters.eq((String)"_id", (Object)id)).first();
    }

    @Override
    public VitamDocument<?> getDocumentByUniqueId(String id, FunctionalAdminCollections collection, String field) {
        if (collection.isMultitenant()) {
            Integer tenantId = ParameterHelper.getTenantParameter();
            return (VitamDocument)collection.getCollection().find(Filters.and((Bson[])new Bson[]{Filters.eq((String)field, (Object)id), Filters.eq((String)"_tenant", (Object)tenantId)})).first();
        }
        return (VitamDocument)collection.getCollection().find(Filters.eq((String)field, (Object)id)).first();
    }

    @Override
    public DbRequestResult findDocuments(JsonNode select, FunctionalAdminCollections collection) throws ReferentialException {
        try {
            SelectParserSingle parser = new SelectParserSingle(collection.getVarNameAdapater());
            parser.parse(select);
            DbRequestSingle dbrequest = new DbRequestSingle(collection.getVitamCollection(), this.ontologyLoader, this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(null));
            return dbrequest.execute(parser.getRequest());
        }
        catch (InvalidCreateOperationException | BadRequestException | DatabaseException | InvalidParseOperationException | SchemaValidationException | VitamDBException e) {
            throw new ReferentialException("find Document Exception", e);
        }
    }

    @Override
    public DbRequestResult findDocumentsWithoutRestrictionOnCurrentTenant(JsonNode select, FunctionalAdminCollections collection) throws ReferentialException {
        try {
            SelectParserSingle parser = new SelectParserSingle(collection.getVarNameAdapater());
            parser.parse(select);
            DbRequestSingle dbRequest = new DbRequestSingle(collection.getVitamCollection(), this.ontologyLoader, this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(null));
            return dbRequest.executeQueryWithoutRestrictionOnCurrentTenant(parser.getRequest());
        }
        catch (InvalidCreateOperationException | BadRequestException | DatabaseException | InvalidParseOperationException | SchemaValidationException | VitamDBException e) {
            throw new ReferentialException("find Document Exception", e);
        }
    }

    @Override
    public DbRequestResult deleteDocument(JsonNode delete, FunctionalAdminCollections collection) throws ReferentialException, BadRequestException, SchemaValidationException {
        try {
            DeleteParserSingle parser = new DeleteParserSingle(collection.getVarNameAdapater());
            parser.parse(delete);
            DbRequestSingle dbrequest = new DbRequestSingle(collection.getVitamCollection(), this.ontologyLoader, this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(null));
            return dbrequest.execute(parser.getRequest());
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            throw new BadRequestException(e);
        }
        catch (DatabaseException | VitamDBException e) {
            throw new ReferentialException("delete Document Exception", e);
        }
    }

    @Override
    public DbRequestResult updateData(JsonNode update, FunctionalAdminCollections collection, Integer version) throws ReferentialException, SchemaValidationException, BadRequestException {
        try {
            UpdateParserSingle parser = new UpdateParserSingle(collection.getVarNameAdapater());
            parser.parse(update);
            DbRequestSingle dbrequest = new DbRequestSingle(collection.getVitamCollection(), this.ontologyLoader, this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(null));
            DocumentValidator documentValidator = ReferentialDocumentValidators.getValidator(collection);
            DbRequestResult result = dbrequest.execute(parser.getRequest(), documentValidator);
            if (result.getDiffs().size() == 0) {
                throw new BadRequestException("Document was not updated as there is no changes");
            }
            return result;
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            throw new BadRequestException(e);
        }
        catch (DatabaseException | VitamDBException e) {
            throw new ReferentialException("Document not found", e);
        }
    }

    @Override
    public void replaceDocument(JsonNode document, String identifierValue, String identifierKey, FunctionalAdminCollections vitamCollection) throws DatabaseException {
        DbRequestSingle dbRequest = new DbRequestSingle(vitamCollection.getVitamCollection(), this.ontologyLoader, this.indexManager.getElasticsearchIndexAliasResolver(vitamCollection).resolveIndexName(null));
        dbRequest.replaceDocument(document, identifierValue, identifierKey, vitamCollection.getVitamCollection());
    }

    public void replaceDocuments(Map<String, JsonNode> documentByIdentifier, String identifierKey, FunctionalAdminCollections vitamCollection) throws DatabaseException {
        DbRequestSingle dbRequest = new DbRequestSingle(vitamCollection.getVitamCollection(), this.ontologyLoader, this.indexManager.getElasticsearchIndexAliasResolver(vitamCollection).resolveIndexName(null));
        dbRequest.replaceDocuments(documentByIdentifier, identifierKey, vitamCollection.getVitamCollection());
    }

    @Override
    public DbRequestResult updateData(JsonNode update, FunctionalAdminCollections collection) throws ReferentialException, SchemaValidationException, BadRequestException {
        return this.updateData(update, collection, 0);
    }

    @Override
    public DbRequestResult insertDocument(JsonNode json, FunctionalAdminCollections collection) throws ReferentialException, SchemaValidationException, DocumentAlreadyExistsException {
        return this.insertDocuments(JsonHandler.createArrayNode().add(json), collection);
    }
}

