/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.common.schema;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import org.bson.Document;

public class Schema
extends VitamDocument<Schema> {
    public static final String TAG_COLLECTION = "Collection";
    public static final String TAG_DESCRIPTION = "Description";
    public static final String TAG_ORIGIN = "Origin";
    public static final String TAG_SHORT_NAME = "ShortName";
    public static final String TAG_IS_OBJECT_NAME = "IsObject";
    public static final String TAG_PATH = "Path";
    public static final String TAG_PATH_CARDINALITY = "Cardinality";
    public static final String CREATIONDATE = "CreationDate";
    public static final String LAST_UPDATE = "LastUpdate";

    public Schema() {
    }

    public Schema(Document document) {
        super(document);
    }

    public Schema(JsonNode content) {
        super(content);
    }

    public Schema(String content) {
        super(content);
    }

    public Schema(Integer tenantId) {
        this.append("_tenant", tenantId);
    }

    public VitamDocument<Schema> newInstance(JsonNode content) {
        return new Schema(content);
    }

    public Schema setId(String id) {
        this.append("_id", id);
        return this;
    }

    public String getDescription() {
        return this.getString(TAG_DESCRIPTION);
    }

    public Schema setDescription(String description) {
        this.append(TAG_DESCRIPTION, description);
        return this;
    }

    public String getCollection() {
        return this.getString(TAG_COLLECTION);
    }

    public Schema setCollection(String collection) {
        this.append(TAG_COLLECTION, collection);
        return this;
    }

    public String getOrigin() {
        return this.getString(TAG_ORIGIN);
    }

    public Schema setOrigin(String origin) {
        this.append(TAG_ORIGIN, origin);
        return this;
    }

    public String getShortName() {
        return this.getString(TAG_SHORT_NAME);
    }

    public Schema setShortName(String shortName) {
        this.append(TAG_SHORT_NAME, shortName);
        return this;
    }

    public boolean getIsObject() {
        return this.getBoolean(TAG_IS_OBJECT_NAME, false);
    }

    public Schema setIsObject(boolean isObject) {
        this.append(TAG_IS_OBJECT_NAME, isObject);
        return this;
    }

    public String getPath() {
        return this.getString(TAG_PATH);
    }

    public Schema setPath(String path) {
        this.append(TAG_PATH, path);
        return this;
    }

    public String getCardinality() {
        return this.getString(TAG_PATH_CARDINALITY);
    }

    public Schema setCardinality(String cardinality) {
        this.append(TAG_PATH_CARDINALITY, cardinality);
        return this;
    }

    public String getCreationdate() {
        return this.getString(CREATIONDATE);
    }

    public Schema setCreationdate(String creationdate) {
        this.append(CREATIONDATE, creationdate);
        return this;
    }

    public String getLastupdate() {
        return this.getString(LAST_UPDATE);
    }

    public Schema setLastupdate(String lastupdate) {
        this.append(LAST_UPDATE, lastupdate);
        return this;
    }
}

