/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.common.config;

import fr.gouv.vitam.common.model.config.CollectionConfiguration;
import fr.gouv.vitam.common.model.config.CollectionConfigurationUtils;
import fr.gouv.vitam.functional.administration.common.config.AdminManagementConfiguration;
import fr.gouv.vitam.functional.administration.common.config.FunctionalAdminIndexationConfiguration;

public class AdminManagementConfigurationValidator {
    public static void validateConfiguration(AdminManagementConfiguration adminManagementConfiguration) {
        if (adminManagementConfiguration == null) {
            throw new IllegalStateException("Invalid configuration. Null config");
        }
        AdminManagementConfigurationValidator.validateIndexationConfiguration(adminManagementConfiguration.getIndexationConfiguration());
    }

    private static void validateIndexationConfiguration(FunctionalAdminIndexationConfiguration indexationConfiguration) {
        if (indexationConfiguration == null) {
            throw new IllegalStateException("Invalid configuration. Missing ES tenant indexation");
        }
        if (indexationConfiguration.getDefaultConfiguration() == null) {
            throw new IllegalStateException("Invalid configuration. Missing default configuration");
        }
        CollectionConfigurationUtils.validate((CollectionConfiguration)indexationConfiguration.getDefaultConfiguration(), (boolean)false);
        for (CollectionConfiguration collectionConfiguration : indexationConfiguration.getCollectionConfigurationMap().values()) {
            CollectionConfigurationUtils.validate((CollectionConfiguration)collectionConfiguration, (boolean)true);
        }
    }
}

