/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.common;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.model.administration.ActivationStatus;
import java.util.Set;
import org.bson.Document;

public class AccessContract
extends VitamDocument<AccessContract> {
    public static final String IDENTIFIER = "Identifier";
    public static final String NAME = "Name";
    public static final String DESCRIPTION = "Description";
    public static final String STATUS = "Status";
    public static final String ORIGINATINGAGENCIES = "OriginatingAgencies";
    public static final String CREATIONDATE = "CreationDate";
    public static final String LAST_UPDATE = "LastUpdate";
    public static final String ACTIVATIONDATE = "ActivationDate";
    public static final String DEACTIVATIONDATE = "DeactivationDate";

    public AccessContract() {
    }

    public AccessContract(Document document) {
        super(document);
    }

    public AccessContract(JsonNode content) {
        super(content);
    }

    public AccessContract(String content) {
        super(content);
    }

    public AccessContract(Integer tenantId) {
        this.append("_tenant", tenantId);
    }

    public VitamDocument<AccessContract> newInstance(JsonNode content) {
        return new AccessContract(content);
    }

    public AccessContract setId(String id) {
        this.append("_id", id);
        return this;
    }

    public String getName() {
        return this.getString(NAME);
    }

    public AccessContract setName(String name) {
        this.append(NAME, name);
        return this;
    }

    public String getDescription() {
        return this.getString(DESCRIPTION);
    }

    public AccessContract setDescription(String description) {
        this.append(DESCRIPTION, description);
        return this;
    }

    public ActivationStatus getStatus() {
        String status = this.getString(STATUS);
        if (status == null) {
            return null;
        }
        try {
            return ActivationStatus.valueOf((String)status);
        }
        catch (IllegalArgumentException exp) {
            throw new IllegalStateException("invalid STATUS value " + status);
        }
    }

    public AccessContract setStatus(ActivationStatus status) {
        this.append(STATUS, status.name());
        return this;
    }

    public Set<String> getOriginatingAgencies() {
        return (Set)this.get(ORIGINATINGAGENCIES);
    }

    public AccessContract setOriginatingAgencies(Set<String> originatingAgencies) {
        this.append(ORIGINATINGAGENCIES, originatingAgencies);
        return this;
    }

    public String getCreationdate() {
        return this.getString(CREATIONDATE);
    }

    public AccessContract setCreationdate(String creationdate) {
        this.append(CREATIONDATE, creationdate);
        return this;
    }

    public String getLastupdate() {
        return this.getString(LAST_UPDATE);
    }

    public AccessContract setLastupdate(String lastupdate) {
        this.append(LAST_UPDATE, lastupdate);
        return this;
    }

    public String getActivationdate() {
        return this.getString(ACTIVATIONDATE);
    }

    public AccessContract setActivationdate(String activationdate) {
        this.append(ACTIVATIONDATE, activationdate);
        return this;
    }

    public String getDeactivationdate() {
        return this.getString(DEACTIVATIONDATE);
    }

    public AccessContract setDeactivationdate(String deactivationdate) {
        this.append(DEACTIVATIONDATE, deactivationdate);
        return this;
    }
}

