/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.management.client;

import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.client.VitamClientFactory;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.client.configuration.ClientConfigurationImpl;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClient;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientMock;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientRest;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class ProcessingManagementClientFactory
extends VitamClientFactory<ProcessingManagementClient> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ProcessingManagementClientFactory.class);
    private static final String RESOURCE_PATH = "/processing/v1";
    private static final String CONFIGURATION_FILENAME = "processing-client.conf";
    private static final ProcessingManagementClientFactory PROCESSING_MANAGEMENT_CLIENT_FACTORY = new ProcessingManagementClientFactory();

    private ProcessingManagementClientFactory() {
        super((ClientConfiguration)ProcessingManagementClientFactory.changeConfigurationFile(CONFIGURATION_FILENAME), RESOURCE_PATH, false);
    }

    public static final ProcessingManagementClientFactory getInstance() {
        return PROCESSING_MANAGEMENT_CLIENT_FACTORY;
    }

    public ProcessingManagementClient getClient() {
        ProcessingManagementClient client;
        switch (this.getVitamClientType()) {
            case MOCK: {
                client = new ProcessingManagementClientMock();
                break;
            }
            case PRODUCTION: {
                client = new ProcessingManagementClientRest(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Worker client type unknown");
            }
        }
        return client;
    }

    static final ClientConfigurationImpl changeConfigurationFile(String configurationPath) {
        ClientConfigurationImpl configuration = null;
        try {
            configuration = (ClientConfigurationImpl)PropertiesUtils.readYaml((File)PropertiesUtils.findFile((String)configurationPath), ClientConfigurationImpl.class);
        }
        catch (IOException fnf) {
            LOGGER.debug("Error when retrieving configuration file {}, using mock", (Object)CONFIGURATION_FILENAME, (Object)fnf);
        }
        if (configuration == null) {
            LOGGER.error("Error when retrieving configuration file {}, using mock", (Object)CONFIGURATION_FILENAME);
        }
        return configuration;
    }

    public static final void changeConfigurationUrl(String urlString) {
        try {
            URI url = new URI(urlString);
            LOGGER.info("Change configuration using " + url.getHost() + ":" + url.getPort());
            ProcessingManagementClientFactory.changeMode(new ClientConfigurationImpl(url.getHost(), url.getPort()));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Cannot parse the URI: " + urlString, e);
        }
    }

    public static final void changeMode(ClientConfigurationImpl configuration) {
        ProcessingManagementClientFactory.getInstance().initialisation((ClientConfiguration)configuration, ProcessingManagementClientFactory.getInstance().getResourcePath());
    }
}

