/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.xml;

import fr.gouv.vitam.common.xml.SecureXMLFactoryUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringUtils;

public final class XmlNamespaceUtils {
    private XmlNamespaceUtils() {
    }

    public static String parseXmlNamespace(InputStream inputStream) throws XMLStreamException {
        try (XMLStreamReader xmlStreamReader = SecureXMLFactoryUtils.createSecureXMLStreamReader(inputStream);){
            while (xmlStreamReader.hasNext()) {
                if (xmlStreamReader.next() != 1) continue;
                String string = xmlStreamReader.getNamespaceURI();
                return string;
            }
            throw new XMLStreamException("Expecting xml document");
        }
    }

    public static void transformXMLNamespace(InputStream inputStream, OutputStream outputStream, String sourceNamespace, String targetNamespace) throws TransformerException {
        try {
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            XMLEventReader eventReader = SecureXMLFactoryUtils.createSecureXMLEventReader(inputStream);
            XMLEventWriter eventWriter = outputFactory.createXMLEventWriter(outputStream);
            XMLEventFactory eventFactory = XMLEventFactory.newInstance();
            if (StringUtils.isEmpty((CharSequence)sourceNamespace) || StringUtils.isEmpty((CharSequence)targetNamespace)) {
                throw new TransformerException("Source and target namespaces are required");
            }
            while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                if (event.isStartElement()) {
                    eventWriter.add(XmlNamespaceUtils.transformStartElement(event.asStartElement(), eventFactory, sourceNamespace, targetNamespace));
                    continue;
                }
                if (event.isEndElement()) {
                    eventWriter.add(XmlNamespaceUtils.transformEndElement(event.asEndElement(), eventFactory, sourceNamespace, targetNamespace));
                    continue;
                }
                eventWriter.add(event);
            }
            eventReader.close();
            eventWriter.close();
        }
        catch (XMLStreamException e) {
            throw new TransformerException(e);
        }
    }

    private static StartElement transformStartElement(StartElement startElement, XMLEventFactory eventFactory, String sourceNamespace, String targetNamespace) {
        String namespaceURI = startElement.getName().getNamespaceURI();
        Iterator<Namespace> namespaces = XmlNamespaceUtils.transformNamespaces(startElement.getNamespaces(), eventFactory, sourceNamespace, targetNamespace);
        if (sourceNamespace.equals(namespaceURI)) {
            return eventFactory.createStartElement(startElement.getName().getPrefix(), targetNamespace, startElement.getName().getLocalPart(), startElement.getAttributes(), namespaces);
        }
        return eventFactory.createStartElement(startElement.getName().getPrefix(), namespaceURI, startElement.getName().getLocalPart(), startElement.getAttributes(), namespaces);
    }

    private static EndElement transformEndElement(EndElement endElement, XMLEventFactory eventFactory, String sourceNamespace, String targetNamespace) {
        String namespaceURI = endElement.getName().getNamespaceURI();
        if (sourceNamespace.equals(namespaceURI)) {
            return eventFactory.createEndElement(endElement.getName().getPrefix(), targetNamespace, endElement.getName().getLocalPart());
        }
        return endElement;
    }

    private static Iterator<Namespace> transformNamespaces(final Iterator<Namespace> namespaces, final XMLEventFactory eventFactory, final String sourceNamespace, final String targetNamespace) {
        return new Iterator<Namespace>(){

            @Override
            public boolean hasNext() {
                return namespaces.hasNext();
            }

            @Override
            public Namespace next() {
                Namespace ns = (Namespace)namespaces.next();
                if (sourceNamespace.equals(ns.getNamespaceURI())) {
                    return eventFactory.createNamespace(ns.getPrefix(), targetNamespace);
                }
                return ns;
            }
        };
    }
}

