/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@VisibleForTesting
public final class JsonSorter {
    private JsonSorter() {
    }

    @VisibleForTesting
    public static void sortJsonEntriesByKeys(JsonNode jsonNode, List<String> orderedKeys) {
        if (jsonNode == null) {
            return;
        }
        Iterator it = jsonNode.elements();
        while (it.hasNext()) {
            JsonNode value = (JsonNode)it.next();
            JsonSorter.sortJsonEntriesByKeys(value, orderedKeys);
        }
        if (jsonNode.isArray() && jsonNode.size() > 1 && jsonNode.get(0).isObject()) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            ArrayList items = new ArrayList();
            jsonNode.forEach(i -> items.add((ObjectNode)i));
            items.sort((node1, node2) -> {
                for (String sortKey : orderedKeys) {
                    JsonNode jsonValue1 = node1.get(sortKey);
                    JsonNode jsonValue2 = node2.get(sortKey);
                    if (jsonValue1 == null && jsonValue2 == null) continue;
                    if (jsonValue1 == null) {
                        return -1;
                    }
                    if (jsonValue2 == null) {
                        return 1;
                    }
                    if (jsonValue1.isNull() && jsonValue2.isNull()) continue;
                    if (jsonValue1.isNull()) {
                        return -1;
                    }
                    if (jsonValue2.isNull()) {
                        return 1;
                    }
                    int sort = jsonValue1.asText().compareTo(node2.get(sortKey).asText());
                    if (sort == 0) continue;
                    return sort;
                }
                return 1;
            });
            arrayNode.removeAll();
            arrayNode.addAll(items);
        }
    }
}

