/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.thread;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.VitamSession;
import fr.gouv.vitam.common.thread.VitamThreadFactory;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.jetty.util.thread.ThreadPool;

public class VitamThreadPoolExecutor
extends ThreadPoolExecutor
implements ThreadPool {
    private static final VitamThreadPoolExecutor VITAM_THREAD_POOL_EXECUTOR = new VitamThreadPoolExecutor();
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(VitamThreadPoolExecutor.class);

    public VitamThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, VitamThreadFactory.getInstance());
    }

    public VitamThreadPoolExecutor() {
        this(VitamConfiguration.getMinimumThreadPoolSize(), Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    public VitamThreadPoolExecutor(int minimumAvailableThreads) {
        this(minimumAvailableThreads, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    public static VitamThreadPoolExecutor getDefaultExecutor() {
        return VITAM_THREAD_POOL_EXECUTOR;
    }

    @Override
    public void execute(Runnable command) {
        VitamRunnable vitamRunnable;
        Thread currentThread = Thread.currentThread();
        if (LOGGER.isDebugEnabled()) {
            String formattedStack = Arrays.stream(currentThread.getStackTrace()).map(StackTraceElement::toString).skip(2L).limit(3L).collect(Collectors.joining(" -> ", "[", "]"));
            LOGGER.debug(command.toString() + " from " + formattedStack);
        }
        if (currentThread instanceof VitamThreadFactory.VitamThread) {
            VitamSession session = VitamSession.from(((VitamThreadFactory.VitamThread)currentThread).getVitamSession());
            vitamRunnable = new VitamRunnable(command, session);
            LOGGER.debug("VitamSession {} propagated from thread {} to runnable {}", new Object[]{session, currentThread.getName(), vitamRunnable});
        } else {
            vitamRunnable = new VitamRunnable(command);
        }
        super.execute(vitamRunnable);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        Thread currentThread = Thread.currentThread();
        if (r instanceof VitamRunnable) {
            VitamSession session = ((VitamRunnable)r).getSession();
            if (currentThread instanceof VitamThreadFactory.VitamThread) {
                if (session == null) {
                    LOGGER.debug("VitamSession was null in runnable {} ; nothing to propagate.", (Object)r);
                } else {
                    ((VitamThreadFactory.VitamThread)currentThread).getVitamSession().mutateFrom(session);
                    LOGGER.debug("VitamSession {} propagated from runnable {} to thread {}", new Object[]{session, r, currentThread.getName()});
                }
            } else {
                LOGGER.warn("Wrong state, eventually coding error : found a thread {} that was not a VitamThread in a VitamThreadPoolExecutor...", (Object)currentThread.getName());
            }
        } else {
            LOGGER.warn("Wrong state, eventually coding error : inside a VitamThreadPoolExecutor, trying to setUp a thread with a Runnable that was not a VitamRunnable ...");
        }
        super.beforeExecute(t, r);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof VitamThreadFactory.VitamThread) {
            VitamThreadFactory.VitamThread vitamThread = (VitamThreadFactory.VitamThread)currentThread;
            LOGGER.debug("VitamSession {} unregistered in thread {}", (Object)vitamThread.getVitamSession(), (Object)currentThread.getName());
            vitamThread.getVitamSession().erase();
        } else {
            LOGGER.warn("Wrong state, eventually coding error : found a thread {} that was not a VitamThread in a VitamThreadPoolExecutor...", (Object)currentThread.getName());
        }
    }

    public void join() throws InterruptedException {
        while (this.awaitTermination(3600L, TimeUnit.SECONDS)) {
        }
    }

    public int getThreads() {
        return this.getPoolSize();
    }

    public int getIdleThreads() {
        return this.getPoolSize() - this.getActiveCount();
    }

    public boolean isLowOnThreads() {
        return false;
    }

    private static final class VitamRunnable
    implements Runnable {
        private final Runnable command;
        private final VitamSession session;

        public VitamRunnable(Runnable command, VitamSession session) {
            ParametersChecker.checkParameter((String)"command should not be null", (Object[])new Object[]{command});
            this.command = command;
            this.session = session;
        }

        public VitamRunnable(Runnable command) {
            this(command, null);
        }

        @Override
        public void run() {
            this.command.run();
        }

        public VitamSession getSession() {
            return this.session;
        }
    }
}

