/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.stream;

import java.io.IOException;
import java.io.InputStream;

public class SizedInputStream
extends InputStream {
    private final InputStream is;
    private long size = 0L;

    public SizedInputStream(InputStream is) {
        this.is = is;
    }

    @Override
    public int read() throws IOException {
        int res = this.is.read();
        if (res != -1) {
            ++this.size;
        }
        return res;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int res = this.is.read(b);
        if (res != -1) {
            this.size += (long)res;
        }
        return res;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int res = this.is.read(b, off, len);
        if (res != -1) {
            this.size += (long)res;
        }
        return res;
    }

    public long getSize() {
        return this.size;
    }
}

