/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.stream;

import fr.gouv.vitam.common.stream.ExactSizeInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.Vector;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class PrependedMultiplexedInputStream
extends ProxyInputStream {
    private static final long LONG_SIZE = 8L;
    private final long size;

    public PrependedMultiplexedInputStream(InputStream firstEntryStream, long firstEntrySize, InputStream multiplexedInputStream, long multiplexedInputStreamSize) throws IOException {
        super(PrependedMultiplexedInputStream.buildSequence(firstEntryStream, firstEntrySize, multiplexedInputStream, multiplexedInputStreamSize));
        this.size = 8L + firstEntrySize + multiplexedInputStreamSize;
    }

    public long size() {
        return this.size;
    }

    private static InputStream buildSequence(InputStream firstEntryStream, long firstEntrySize, InputStream multiplexedInputStream, long multiplexedInputStreamSize) throws IOException {
        ByteArrayOutputStream firstEntrySizeOutputStream = new ByteArrayOutputStream();
        try (DataOutputStream firstEntrySizeDataOutputStream = new DataOutputStream((OutputStream)firstEntrySizeOutputStream);){
            firstEntrySizeDataOutputStream.writeLong(firstEntrySize);
            firstEntrySizeDataOutputStream.flush();
        }
        InputStream firstEntrySizeInputStream = firstEntrySizeOutputStream.toInputStream();
        Vector<InputStream> streams = new Vector<InputStream>();
        streams.add(firstEntrySizeInputStream);
        streams.add(new ExactSizeInputStream(firstEntryStream, firstEntrySize));
        streams.add(new ExactSizeInputStream(multiplexedInputStream, multiplexedInputStreamSize));
        return new SequenceInputStream(streams.elements());
    }
}

