/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.stream;

import fr.gouv.vitam.common.stream.ExactSizeInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class MultiplexedStreamWriter {
    private static final long LONG_SIZE = 8L;
    private static final long EOF_MARKER = -1L;
    private final DataOutputStream dataOutputStream;

    public MultiplexedStreamWriter(OutputStream outputStream) {
        this.dataOutputStream = new DataOutputStream(outputStream);
    }

    public void appendEntry(long size, InputStream inputStream) throws IOException {
        this.dataOutputStream.writeLong(size);
        ExactSizeInputStream exactSizeInputStream = new ExactSizeInputStream(inputStream, size);
        IOUtils.copy((InputStream)exactSizeInputStream, (OutputStream)this.dataOutputStream);
    }

    public void appendEndOfFile() throws IOException {
        this.dataOutputStream.writeLong(-1L);
        this.dataOutputStream.flush();
    }

    public static long getTotalStreamSize(List<Long> fileSizes) {
        long totalSize = 0L;
        for (Long fileSize : fileSizes) {
            totalSize += 8L + fileSize;
        }
        return totalSize += 8L;
    }
}

