/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.stream;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.VitamAutoCloseable;
import fr.gouv.vitam.common.stream.BoundedByteBuffer;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.common.thread.VitamThreadPoolExecutor;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;

public class MultiplePipedInputStream
implements VitamAutoCloseable {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MultiplePipedInputStream.class);
    private static final ExecutorService EXECUTOR_THREAD_READER = new VitamThreadPoolExecutor();
    private final int nbCopy;
    private final BoundedByteBuffer boundedByteBuffer;
    private final InputStream source;
    private volatile IOException lastException = null;

    public MultiplePipedInputStream(InputStream source, int nbCopy) {
        ParametersChecker.checkParameter((String)"InputStream cannot be null", (Object[])new Object[]{source});
        ParametersChecker.checkValue((String)"nbCopy", (long)nbCopy, (long)1L);
        this.nbCopy = nbCopy;
        this.source = source;
        int bufferSize = VitamConfiguration.getChunkSize() * VitamConfiguration.getBufferNumber();
        this.boundedByteBuffer = new BoundedByteBuffer(bufferSize, nbCopy);
        EXECUTOR_THREAD_READER.execute(() -> {
            try {
                this.copy();
            }
            catch (IOException e) {
                LOGGER.error((Throwable)e);
                this.lastException = e;
            }
        });
    }

    public InputStream getInputStream(int rank) {
        if (rank < 0 || rank >= this.nbCopy) {
            throw new IllegalArgumentException("Rank is invalid");
        }
        return this.boundedByteBuffer.getReader(rank);
    }

    public void throwLastException() throws IOException {
        if (this.lastException != null) {
            throw this.lastException;
        }
    }

    protected final void copy() throws IOException {
        try (BoundedByteBuffer.Writer writer = this.boundedByteBuffer.getWriter();){
            int n;
            byte[] buffer = new byte[VitamConfiguration.getChunkSize().intValue()];
            while (-1 != (n = this.source.read(buffer))) {
                writer.write(buffer, 0, n);
            }
            writer.writeEOF();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted thread", e);
        }
    }

    public void close() {
        this.boundedByteBuffer.close();
        StreamUtils.closeSilently((InputStream)this.source);
    }
}

