/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.stream;

import fr.gouv.vitam.common.logging.SysErrLogger;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.commons.io.output.ProxyOutputStream;

public class ExtendedFileOutputStream
extends ProxyOutputStream {
    private final FileChannel fileChannel;
    private final boolean fsyncOnClose;
    private boolean writeMetadata = true;
    private boolean closed = false;

    public ExtendedFileOutputStream(Path filepath, boolean fsyncOnClose) throws IOException {
        super(null);
        this.fileChannel = FileChannel.open(filepath, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        this.fsyncOnClose = fsyncOnClose;
        this.out = new BufferedOutputStream(Channels.newOutputStream(this.fileChannel));
    }

    public void fsync() throws IOException {
        this.flush();
        this.fileChannel.force(this.writeMetadata);
        this.writeMetadata = false;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.fsyncOnClose) {
            try {
                this.fsync();
            }
            catch (IOException ex) {
                try {
                    super.close();
                }
                catch (IOException ex2) {
                    SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)ex2);
                }
                throw ex;
            }
        }
        super.close();
    }
}

