/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.serverv2;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Sets;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.client.MockOrRestClient;
import fr.gouv.vitam.common.client.VitamClientFactory;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamApplicationServerException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.SysErrLogger;
import fr.gouv.vitam.common.security.filter.AuthorizationFilter;
import fr.gouv.vitam.common.server.VitamServer;
import fr.gouv.vitam.common.server.VitamServerFactory;
import fr.gouv.vitam.common.server.application.resources.AdminStatusResource;
import fr.gouv.vitam.common.serverv2.SslConfig;
import fr.gouv.vitam.common.tenant.filter.TenantFilter;
import fr.gouv.vitam.common.xsrf.filter.XSRFFilter;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ServerSocketFactory;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.apache.shiro.util.Assert;
import org.apache.shiro.web.env.EnvironmentLoaderListener;
import org.apache.shiro.web.servlet.ShiroFilter;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;

public class VitamServerTestRunner {
    public static final String LOCALHOST = "localhost";
    private final VitamServer server;
    private final VitamClientFactoryInterface<?> factory;
    private final Class<? extends Application> application;
    private final Class<? extends Application> adminAapplication;
    public static final int MIN_PORT = 11112;
    private static final int MAX_PORT = 65535;
    private final int businessPort;
    private final int adminPort;
    private final Set<Integer> portAlreadyUsed = new HashSet<Integer>();
    private static final Set<Integer> usedPort = Sets.newConcurrentHashSet();

    public VitamServerTestRunner(Class<? extends Application> application, Class<? extends Application> adminApplication) {
        this(application, adminApplication, false);
    }

    public VitamServerTestRunner(Class<? extends Application> application, Class<? extends Application> adminApplication, boolean hasAuthorizationFilter) {
        this(application, adminApplication, false, hasAuthorizationFilter);
    }

    public VitamServerTestRunner(Class<? extends Application> application, Class<? extends Application> adminApplication, boolean hasTenantFilter, boolean hasAuthorizationFilter) {
        this(application, adminApplication, hasTenantFilter, hasAuthorizationFilter, false);
    }

    public VitamServerTestRunner(Class<? extends Application> application, Class<? extends Application> adminApplication, boolean hasTenantFilter, boolean hasAuthorizationFilter, boolean hasSession) {
        this(application, adminApplication, hasTenantFilter, hasAuthorizationFilter, hasSession, false);
    }

    public VitamServerTestRunner(Class<? extends Application> application, Class<? extends Application> adminApplication, boolean hasTenantFilter, boolean hasAuthorizationFilter, boolean hasSession, boolean hasShiroFilter) {
        this(application, adminApplication, hasTenantFilter, hasAuthorizationFilter, hasSession, hasShiroFilter, false);
    }

    public VitamServerTestRunner(Class<? extends Application> application, Class<? extends Application> adminApplication, boolean hasTenantFilter, boolean hasAuthorizationFilter, boolean hasSession, boolean hasShiroFilter, boolean hasXsrFilter) {
        this(application, adminApplication, null, null, hasTenantFilter, hasAuthorizationFilter, hasSession, hasShiroFilter, hasXsrFilter);
    }

    public VitamServerTestRunner(Class<? extends Application> application, Class<? extends Application> adminApplication, VitamClientFactoryInterface<?> factory) {
        this(application, adminApplication, factory, false);
    }

    public VitamServerTestRunner(Class<? extends Application> application, Class<? extends Application> adminApplication, VitamClientFactoryInterface<?> factory, boolean hasAuthorizationFilter) {
        this(application, adminApplication, factory, false, hasAuthorizationFilter);
    }

    public VitamServerTestRunner(Class<? extends Application> application, Class<? extends Application> adminApplication, VitamClientFactoryInterface<?> factory, boolean hasTenantFilter, boolean hasAuthorizationFilter) {
        this(application, adminApplication, factory, hasTenantFilter, hasAuthorizationFilter, false);
    }

    public VitamServerTestRunner(Class<? extends Application> application, Class<? extends Application> adminApplication, VitamClientFactoryInterface<?> factory, boolean hasTenantFilter, boolean hasAuthorizationFilter, boolean hasSession) {
        this(application, adminApplication, null, factory, hasTenantFilter, hasAuthorizationFilter, hasSession, false, false);
    }

    public VitamServerTestRunner(Class<? extends Application> application) {
        this(application, false);
    }

    public VitamServerTestRunner(Class<? extends Application> application, boolean hasAuthorizationFilter) {
        this(application, false, hasAuthorizationFilter);
    }

    public VitamServerTestRunner(Class<? extends Application> application, boolean hasTenantFilter, boolean hasAuthorizationFilter) {
        this(application, hasTenantFilter, hasAuthorizationFilter, false);
    }

    public VitamServerTestRunner(Class<? extends Application> application, boolean hasTenantFilter, boolean hasAuthorizationFilter, boolean hasSession) {
        this(application, hasTenantFilter, hasAuthorizationFilter, hasSession, false);
    }

    public VitamServerTestRunner(Class<? extends Application> application, boolean hasTenantFilter, boolean hasAuthorizationFilter, boolean hasSession, boolean hasShiroFilter) {
        this(application, hasTenantFilter, hasAuthorizationFilter, hasSession, hasShiroFilter, false);
    }

    public VitamServerTestRunner(Class<? extends Application> application, boolean hasTenantFilter, boolean hasAuthorizationFilter, boolean hasSession, boolean hasShiroFilter, boolean hasXsrFilter) {
        this(application, (VitamClientFactoryInterface)null, hasTenantFilter, hasAuthorizationFilter, hasSession, hasShiroFilter, hasXsrFilter);
    }

    public VitamServerTestRunner(Class<? extends Application> application, VitamClientFactoryInterface<?> factory) {
        this(application, factory, false);
    }

    public VitamServerTestRunner(Class<? extends Application> application, VitamClientFactoryInterface<?> factory, boolean hasAuthorizationFilter) {
        this(application, factory, false, hasAuthorizationFilter);
    }

    public VitamServerTestRunner(Class<? extends Application> application, VitamClientFactoryInterface<?> factory, boolean hasTenantFilter, boolean hasAuthorizationFilter) {
        this(application, factory, hasTenantFilter, hasAuthorizationFilter, false);
    }

    public VitamServerTestRunner(Class<? extends Application> application, VitamClientFactoryInterface<?> factory, boolean hasTenantFilter, boolean hasAuthorizationFilter, boolean hasSession) {
        this(application, factory, hasTenantFilter, hasAuthorizationFilter, hasSession, false, false);
    }

    public VitamServerTestRunner(Class<? extends Application> application, VitamClientFactoryInterface<?> factory, boolean hasTenantFilter, boolean hasAuthorizationFilter, boolean hasSession, boolean hasShiroFilter, boolean hasXsrFilter) {
        this(application, application, null, factory, hasTenantFilter, hasAuthorizationFilter, hasSession, hasShiroFilter, hasXsrFilter);
    }

    public VitamServerTestRunner(Class<? extends Application> application, Class<? extends Application> adminApplication, SslConfig configuration, VitamClientFactoryInterface<?> factory, boolean hasTenantFilter, boolean hasAuthorizationFilter, boolean hasSession, boolean hasShiroFilter, boolean hasXsrFilter) {
        this.application = application;
        this.adminAapplication = adminApplication;
        this.factory = factory;
        this.businessPort = this.getAvailablePort();
        this.adminPort = this.getAvailablePort();
        if (null != configuration) {
            this.server = VitamServerFactory.newVitamServerWithoutConnector(this.businessPort);
            this.createSslConnector(configuration);
        } else {
            this.server = VitamServerFactory.newVitamServer(this.businessPort);
            ServerConnector connector = (ServerConnector)this.server.getServer().getConnectors()[0];
            connector.setName("business");
        }
        this.prepare(hasTenantFilter, hasAuthorizationFilter, hasSession, hasShiroFilter, hasXsrFilter);
        if (null != factory) {
            if (null != factory.getClientConfiguration()) {
                factory.getClientConfiguration().setServerHost(LOCALHOST);
            }
            factory.changeServerPort(this.businessPort);
        }
        VitamConfiguration.setHttpClientWaitingTime((int)1);
        VitamConfiguration.setHttpClientRandomWaitingSleep((int)1);
        VitamConfiguration.setHttpClientFirstAttemptWaitingTime((int)1);
        VitamConfiguration.setHttpClientRetry((int)3);
    }

    private void createSslConnector(SslConfig configuration) {
        HttpConfiguration https = new HttpConfiguration();
        https.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(configuration.getKeyStorePath());
        sslContextFactory.setKeyStorePassword(configuration.getKeyStorePassword());
        sslContextFactory.setKeyManagerPassword(configuration.getKeyStorePassword());
        sslContextFactory.setTrustStorePath(configuration.getTrustStorePath());
        sslContextFactory.setTrustStorePassword(configuration.getTrustStorePassword());
        sslContextFactory.setTrustStoreType("JKS");
        sslContextFactory.setNeedClientAuth(false);
        sslContextFactory.setWantClientAuth(true);
        sslContextFactory.setIncludeCipherSuites(new String[]{"TLS_ECDHE.*", "TLS_DHE_RSA.*"});
        sslContextFactory.setIncludeProtocols(new String[]{"TLSv1.2"});
        sslContextFactory.setExcludeCipherSuites(new String[]{".*NULL.*", ".*RC4.*", ".*MD5.*", ".*DES.*", ".*DSS."});
        sslContextFactory.setUseCipherSuitesOrder(true);
        sslContextFactory.setRenegotiationAllowed(true);
        SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslContextFactory, "http/1.1");
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(https);
        ServerConnector sslConnector = new ServerConnector(this.server.getServer(), new ConnectionFactory[]{sslConnectionFactory, httpConnectionFactory});
        sslConnector.setPort(this.businessPort);
        sslConnector.setName("business");
        sslConnector.setHost(LOCALHOST);
        sslConnector.setIdleTimeout(30000L);
        this.server.getServer().addConnector((Connector)sslConnector);
    }

    private void prepare(boolean hasTenantFilter, boolean hasAuthorizationFilter, boolean hasSession, boolean hasShiroFilter, boolean hasXsrFilter) {
        try {
            ContextHandlerCollection applicationHandlers = new ContextHandlerCollection();
            ServletHolder servletHolder = new ServletHolder((Servlet)new HttpServletDispatcher());
            servletHolder.setInitParameter("javax.ws.rs.Application", this.application.getName());
            ServletContextHandler context = new ServletContextHandler(hasSession ? 1 : 0);
            context.addServlet(servletHolder, "/*");
            context.setContextPath("/");
            context.setVirtualHosts(new String[]{"@business"});
            if (hasAuthorizationFilter) {
                VitamConfiguration.setSecret((String)"vitamsecret");
                context.addFilter(AuthorizationFilter.class, "/*", EnumSet.of(DispatcherType.INCLUDE, DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.ERROR, DispatcherType.ASYNC));
            }
            if (hasXsrFilter) {
                context.addFilter(XSRFFilter.class, "/*", EnumSet.of(DispatcherType.INCLUDE, DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.ERROR, DispatcherType.ASYNC));
            }
            if (hasShiroFilter) {
                this.addShiroFilter(context);
            }
            if (hasTenantFilter) {
                this.addTenantFilter(context, VitamConfiguration.getTenants());
            }
            StatisticsHandler stats = new StatisticsHandler();
            stats.setHandler((Handler)context);
            applicationHandlers.addHandler((Handler)stats);
            ServerConnector admin = new ServerConnector(this.server.getServer());
            admin.setName("admin");
            admin.setHost(LOCALHOST);
            admin.setPort(this.adminPort);
            this.server.getServer().addConnector((Connector)admin);
            ServletHolder servletHolderAdmin = new ServletHolder((Servlet)new HttpServletDispatcher());
            servletHolderAdmin.setInitParameter("javax.ws.rs.Application", this.adminAapplication.getName());
            ServletContextHandler contextAdmin = new ServletContextHandler(hasSession ? 1 : 0);
            contextAdmin.addServlet(servletHolderAdmin, "/*");
            contextAdmin.setVirtualHosts(new String[]{"@admin"});
            StatisticsHandler statsAdmin = new StatisticsHandler();
            statsAdmin.setHandler((Handler)contextAdmin);
            applicationHandlers.addHandler((Handler)statsAdmin);
            this.server.configure((Handler)applicationHandlers);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void after() throws Exception {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            SysErrLogger.FAKE_LOGGER.syserr("", (Throwable)e);
        }
    }

    public MockOrRestClient getClient() {
        return this.factory == null ? null : this.factory.getClient();
    }

    public void runAfter() throws Exception {
        this.after();
        this.releasePort();
        VitamClientFactory.resetConnections();
        try {
            if (null != this.factory) {
                this.factory.shutdown();
            }
        }
        catch (Exception e) {
            SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e);
        }
    }

    public void stop() throws Exception {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            SysErrLogger.FAKE_LOGGER.syserr("", (Throwable)e);
        }
    }

    public void start() throws Exception {
        this.server.start();
    }

    private void addShiroFilter(ServletContextHandler context) throws VitamApplicationServerException {
        File shiroFile;
        try {
            shiroFile = PropertiesUtils.findFile((String)"shiro.ini");
        }
        catch (FileNotFoundException e) {
            throw new VitamApplicationServerException(e.getMessage());
        }
        context.setInitParameter("shiroConfigLocations", "file:" + shiroFile.getAbsolutePath());
        context.addEventListener((EventListener)new EnvironmentLoaderListener());
        context.addFilter(ShiroFilter.class, "/*", EnumSet.of(DispatcherType.INCLUDE, DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.ERROR, DispatcherType.ASYNC));
    }

    private void addTenantFilter(ServletContextHandler context, List<Integer> tenantList) throws VitamApplicationServerException {
        try {
            JsonNode node = JsonHandler.toJsonNode(tenantList);
            context.setInitParameter("tenantList", JsonHandler.unprettyPrint((Object)node));
            context.addFilter(TenantFilter.class, "/*", EnumSet.of(DispatcherType.INCLUDE, DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.ERROR, DispatcherType.ASYNC));
        }
        catch (InvalidParseOperationException e) {
            throw new VitamApplicationServerException(e.getMessage());
        }
    }

    private final synchronized int getAvailablePort() {
        while (true) {
            Integer port;
            if (!this.portAlreadyUsed.contains(port = Integer.valueOf(this.getPort()))) {
                this.portAlreadyUsed.add(port);
                return port;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                SysErrLogger.FAKE_LOGGER.syserr("", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private final int getPort() {
        return SocketType.TCP.findAvailablePort(11112, 65535);
    }

    public final synchronized void releasePort() {
        this.portAlreadyUsed.remove(this.businessPort);
        this.portAlreadyUsed.remove(this.adminPort);
    }

    public int getBusinessPort() {
        return this.businessPort;
    }

    public int getAdminPort() {
        return this.adminPort;
    }

    private static enum SocketType {
        TCP{

            @Override
            protected boolean isPortAvailable(int port) {
                if (usedPort.contains(port)) {
                    return false;
                }
                try {
                    ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getByName(VitamServerTestRunner.LOCALHOST));
                    serverSocket.close();
                    return true;
                }
                catch (Exception ex) {
                    return false;
                }
            }
        }
        ,
        UDP{

            @Override
            protected boolean isPortAvailable(int port) {
                if (usedPort.contains(port)) {
                    return false;
                }
                try {
                    DatagramSocket socket = new DatagramSocket(port, InetAddress.getByName(VitamServerTestRunner.LOCALHOST));
                    socket.close();
                    return true;
                }
                catch (Exception ex) {
                    return false;
                }
            }
        };


        protected abstract boolean isPortAvailable(int var1);

        int findAvailablePort(int minPort, int maxPort) {
            Assert.isTrue((minPort > 0 ? 1 : 0) != 0, (String)"'minPort' must be greater than 0");
            Assert.isTrue((maxPort >= minPort ? 1 : 0) != 0, (String)"'maxPort' must be greater than or equal to 'minPort'");
            Assert.isTrue((maxPort <= 65535 ? 1 : 0) != 0, (String)"'maxPort' must be less than or equal to 65535");
            Integer candidatePort = null;
            for (int port = minPort; port <= maxPort; ++port) {
                if (!this.isPortAvailable(port)) continue;
                usedPort.add(port);
                candidatePort = port;
                break;
            }
            if (candidatePort == null) {
                throw new IllegalStateException(String.format("Could not find an available %s port in the range [%d, %d] after %d attempts", this.name(), minPort, maxPort, usedPort.size()));
            }
            return candidatePort;
        }
    }

    @ApplicationPath(value="/")
    public static class AdminApp
    extends Application {
        public Set<Object> getSingletons() {
            return Sets.newHashSet((Object[])new Object[]{new AdminStatusResource()});
        }
    }
}

