/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.server.application.configuration;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.server.application.configuration.DbConfiguration;
import fr.gouv.vitam.common.server.application.configuration.DefaultVitamApplicationConfiguration;
import fr.gouv.vitam.common.server.application.configuration.MongoDbNode;
import java.util.List;

public class DbConfigurationImpl
extends DefaultVitamApplicationConfiguration
implements DbConfiguration {
    private static final String PORT_MUST_BE_POSITIVE = "Port must be positive";
    private static final String CONFIGURATION_PARAMETERS = "DbConfiguration parameters";
    private List<MongoDbNode> mongoDbNodes;
    private String dbName;
    private boolean dbAuthentication = false;
    private String dbUserName;
    private String dbPassword;

    public DbConfigurationImpl() {
    }

    public DbConfigurationImpl(List<MongoDbNode> mongoDbNodes, String dbName, boolean dbAuthentication, String dbUserName, String dbPassword) {
        for (MongoDbNode node : mongoDbNodes) {
            ParametersChecker.checkParameter((String)CONFIGURATION_PARAMETERS, (String[])new String[]{node.getDbHost(), dbName});
            if (node.getDbPort() > 0) continue;
            throw new IllegalArgumentException(PORT_MUST_BE_POSITIVE);
        }
        this.mongoDbNodes = mongoDbNodes;
        this.dbName = dbName;
        this.dbAuthentication = dbAuthentication;
        this.dbUserName = dbUserName;
        this.dbPassword = dbPassword;
    }

    public DbConfigurationImpl(List<MongoDbNode> mongoDbNodes, String dbName) {
        for (MongoDbNode node : mongoDbNodes) {
            ParametersChecker.checkParameter((String)CONFIGURATION_PARAMETERS, (String[])new String[]{node.getDbHost(), dbName});
            if (node.getDbPort() > 0) continue;
            throw new IllegalArgumentException(PORT_MUST_BE_POSITIVE);
        }
        this.mongoDbNodes = mongoDbNodes;
        this.dbName = dbName;
        this.dbAuthentication = false;
    }

    @Override
    public List<MongoDbNode> getMongoDbNodes() {
        return this.mongoDbNodes;
    }

    @Override
    public String getDbName() {
        return this.dbName;
    }

    @Override
    public String getDbUserName() {
        return this.dbUserName;
    }

    @Override
    public String getDbPassword() {
        return this.dbPassword;
    }

    @Override
    public boolean isDbAuthentication() {
        return this.dbAuthentication;
    }

    public DbConfigurationImpl setMongoDbNodes(List<MongoDbNode> mongoDbNodes) {
        for (MongoDbNode node : mongoDbNodes) {
            ParametersChecker.checkParameter((String)CONFIGURATION_PARAMETERS, (String[])new String[]{node.getDbHost()});
            if (node.getDbPort() > 0) continue;
            throw new IllegalArgumentException(PORT_MUST_BE_POSITIVE);
        }
        this.mongoDbNodes = mongoDbNodes;
        return this;
    }

    public DbConfigurationImpl setDbName(String dbName) {
        ParametersChecker.checkParameter((String)CONFIGURATION_PARAMETERS, (String[])new String[]{dbName});
        this.dbName = dbName;
        return this;
    }

    public DbConfigurationImpl setDbUserName(String userName) {
        this.dbUserName = userName;
        return this;
    }

    public DbConfigurationImpl setDbPassword(String password) {
        this.dbPassword = password;
        return this;
    }

    public DbConfigurationImpl setDbAuthentication(boolean authentication) {
        this.dbAuthentication = authentication;
        return this;
    }
}

