/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.security.filter;

import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.security.filter.RequestAuthorizationValidator;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;

public class AuthorizationFilter
implements Filter {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AuthorizationFilter.class);
    private final RequestAuthorizationValidator requestAuthorizationValidator;

    public AuthorizationFilter() {
        this(new RequestAuthorizationValidator());
    }

    AuthorizationFilter(RequestAuthorizationValidator requestAuthorizationValidator) {
        this.requestAuthorizationValidator = requestAuthorizationValidator;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.requestAuthorizationValidator.checkAuthorizationHeaders((HttpServletRequest)request)) {
            LOGGER.error("Authorization headers check failed!");
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            httpServletResponse.sendError(Response.Status.UNAUTHORIZED.getStatusCode(), JsonHandler.unprettyPrint((Object)JsonHandler.createObjectNode().put("Error", "Authorization headers check failed!")));
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

