/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model.config;

import fr.gouv.vitam.common.model.config.CollectionConfiguration;

public final class CollectionConfigurationUtils {
    private static final int MAX_REPLICAS = 100;
    private static final int MAX_SHARDS = 1000;
    private static final int MIN_SHARDS = 1;
    private static final int MIN_REPLICAS = 0;

    private CollectionConfigurationUtils() {
    }

    public static void validate(CollectionConfiguration collectionConfiguration, boolean allowNulls) throws IllegalStateException {
        if (!allowNulls && collectionConfiguration.getNumberOfShards() == null) {
            throw new IllegalStateException("Invalid configuration. Missing shards");
        }
        if (!allowNulls && collectionConfiguration.getNumberOfReplicas() == null) {
            throw new IllegalStateException("Invalid configuration. Missing replicas");
        }
        if (collectionConfiguration.getNumberOfShards() != null && (collectionConfiguration.getNumberOfShards() < 1 || collectionConfiguration.getNumberOfShards() > 1000)) {
            throw new IllegalStateException(String.format("Invalid configuration. Invalid number of shards %d. Expected between %d and %d (inclusive)", collectionConfiguration.getNumberOfShards(), 1, 1000));
        }
        if (collectionConfiguration.getNumberOfReplicas() != null && (collectionConfiguration.getNumberOfReplicas() < 0 || collectionConfiguration.getNumberOfReplicas() > 100)) {
            throw new IllegalStateException(String.format("Invalid configuration. Invalid number of replicas %d. Expected between %d and %d (inclusive)", collectionConfiguration.getNumberOfReplicas(), 0, 100));
        }
    }

    public static CollectionConfiguration merge(CollectionConfiguration customConfig, CollectionConfiguration defaultConfig) {
        if (customConfig == null || customConfig.getNumberOfShards() == null && customConfig.getNumberOfReplicas() == null) {
            return defaultConfig;
        }
        if (customConfig.getNumberOfShards() != null && customConfig.getNumberOfReplicas() != null) {
            return customConfig;
        }
        return new CollectionConfiguration().setNumberOfShards(customConfig.getNumberOfShards() != null ? customConfig.getNumberOfShards() : defaultConfig.getNumberOfShards()).setNumberOfReplicas(customConfig.getNumberOfReplicas() != null ? customConfig.getNumberOfReplicas() : defaultConfig.getNumberOfReplicas());
    }
}

