/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model;

import fr.gouv.vitam.common.exception.VitamRuntimeException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class VitamConstants {
    public static final String SIP_FOLDER = "SIP";
    public static final String TAG_RULE_STORAGE = "StorageRule";
    public static final String TAG_RULE_APPRAISAL = "AppraisalRule";
    public static final String TAG_RULE_ACCESS = "AccessRule";
    public static final String TAG_RULE_DISSEMINATION = "DisseminationRule";
    public static final String TAG_RULE_REUSE = "ReuseRule";
    public static final String TAG_RULE_CLASSIFICATION = "ClassificationRule";
    public static final String TAG_RULE_HOLD = "HoldRule";
    public static final String EVERY_ORIGINATING_AGENCY = "EveryOriginatingAgency";
    public static final String MANIFEST_FILE_NAME_REGEX = "^([a-zA-Z0-9_\\-]{0,56}[_-]{1}){0,1}(manifest.xml)\\b";
    private static List<String> ruleTypes = null;
    public static final String URL_ENCODED_SEPARATOR;
    public static final String JSON_EXTENSION = ".json";
    public static final String JSONL_EXTENSION = ".jsonl";
    public static final String DETAILS = " Detail= ";

    private VitamConstants() {
    }

    public static List<String> getSupportedRules() {
        if (ruleTypes == null) {
            ruleTypes = new ArrayList<String>();
            ruleTypes.add(TAG_RULE_ACCESS);
            ruleTypes.add(TAG_RULE_REUSE);
            ruleTypes.add(TAG_RULE_STORAGE);
            ruleTypes.add(TAG_RULE_APPRAISAL);
            ruleTypes.add(TAG_RULE_CLASSIFICATION);
            ruleTypes.add(TAG_RULE_DISSEMINATION);
            ruleTypes.add(TAG_RULE_HOLD);
        }
        return ruleTypes;
    }

    static {
        try {
            URL_ENCODED_SEPARATOR = URLEncoder.encode("/", "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new VitamRuntimeException((Throwable)e);
        }
    }

    public static enum StorageRuleFinalAction {
        RESTRICT_ACCESS("RestrictAccess"),
        TRANSFER("Transfer"),
        COPY("Copy");

        private final String value;

        private StorageRuleFinalAction(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static StorageRuleFinalAction fromValue(String v) throws IllegalArgumentException {
            for (StorageRuleFinalAction c : StorageRuleFinalAction.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }

    public static enum AppraisalRuleFinalAction {
        KEEP("Keep"),
        DESTROY("Destroy");

        private final String value;

        private AppraisalRuleFinalAction(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static AppraisalRuleFinalAction fromValue(String v) throws IllegalArgumentException {
            for (AppraisalRuleFinalAction c : AppraisalRuleFinalAction.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

