/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.metrics;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import io.prometheus.client.Summary;
import java.io.InputStream;
import javax.ws.rs.container.ContainerRequestContext;
import org.apache.commons.io.input.CountingInputStream;

public class RequestLengthCountingInputStreamMetrics
extends CountingInputStream {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(RequestLengthCountingInputStreamMetrics.class);
    public static final Summary RECEIVED_BYTES = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("vitam_requests_size_bytes")).labelNames(new String[]{"tenant", "method"})).help("Vitam requests size in bytes per tenant and method")).register();
    private final ContainerRequestContext requestContext;
    private boolean first = true;

    public RequestLengthCountingInputStreamMetrics(ContainerRequestContext requestContext, InputStream inputStream) {
        super(inputStream);
        ParametersChecker.checkParameter((String)"RequestContext param is required", (Object[])new Object[]{requestContext});
        this.requestContext = requestContext;
    }

    protected void afterRead(int n) {
        if (n == -1 && this.first) {
            this.first = false;
            this.onEndOfFileReached();
        }
        super.afterRead(n);
    }

    private void onEndOfFileReached() {
        try {
            String headerString = this.requestContext.getHeaderString("X-Tenant-Id");
            String tenant = headerString == null ? "unknown_tenant" : headerString;
            String method = this.requestContext.getMethod();
            ((Summary.Child)RECEIVED_BYTES.labels(new String[]{tenant, method})).observe((double)super.getByteCount());
        }
        catch (Exception e) {
            LOGGER.warn((Throwable)e);
        }
    }
}

