/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.mapping.dip;

import fr.gouv.vitam.common.xml.SecureXMLFactoryUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TransformJsonTreeToListOfXmlElement {
    private TransformJsonTreeToListOfXmlElement() {
    }

    public static List<Element> mapJsonToElement(Map<String, ?> map) {
        try {
            DocumentBuilderFactory documentBuilderFactory = SecureXMLFactoryUtils.createSecureDocumentBuilderFactory();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            ArrayList<Element> elementToReturn = new ArrayList<Element>();
            TransformJsonTreeToListOfXmlElement.transformMapToElement(elementToReturn::add, document, map);
            return elementToReturn;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private static void transformMapToElement(Consumer<Element> consumer, Document document, Map<String, ?> map) {
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            if (entry.getKey().startsWith("#")) continue;
            TransformJsonTreeToListOfXmlElement.mapObject(consumer, document, entry.getKey(), entry.getValue());
        }
    }

    private static void mapList(Consumer<Element> consumer, Document document, String key, Object value) {
        List list = (List)value;
        list.forEach(e -> TransformJsonTreeToListOfXmlElement.mapObject(consumer, document, key, e));
    }

    private static void mapObject(Consumer<Element> consumer, Document document, String key, Object value) {
        if (value instanceof String || value instanceof Number || value instanceof Boolean) {
            TransformJsonTreeToListOfXmlElement.mapObject(consumer, document, key, value.toString());
        } else if (value instanceof List) {
            TransformJsonTreeToListOfXmlElement.mapList(consumer, document, key, value);
        } else if (value instanceof Map) {
            Element childElement = document.createElementNS("fr:gouv:culture:archivesdefrance:seda:v2", key);
            TransformJsonTreeToListOfXmlElement.transformMapToElement(childElement::appendChild, document, (Map)value);
            consumer.accept(childElement);
        }
    }

    private static void mapObject(Consumer<Element> consumer, Document document, String key, String value) {
        Element childElement = document.createElementNS("fr:gouv:culture:archivesdefrance:seda:v2", key);
        childElement.appendChild(document.createTextNode(value));
        consumer.accept(childElement);
    }
}

